/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.doctrine.annotation.model;

import com.dubture.doctrine.annotation.model.Annotation;
import com.dubture.doctrine.annotation.model.AnnotationSourceElement;
import com.dubture.doctrine.annotation.model.AnnotationVisitor;
import java.util.LinkedList;
import java.util.List;

public class AnnotationBlock
extends AnnotationSourceElement {
    private List<Annotation> annotations;

    public AnnotationBlock() {
        this.annotations = new LinkedList<Annotation>();
    }

    public AnnotationBlock(List<Annotation> annotations) {
        this.annotations = annotations;
    }

    public void addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public List<Annotation> findAnnotations(String className) {
        LinkedList<Annotation> result = new LinkedList<Annotation>();
        for (Annotation a : this.annotations) {
            if (!a.getClassName().equalsIgnoreCase(className)) continue;
            result.add(a);
        }
        return result;
    }

    public boolean isEmpty() {
        return this.annotations.isEmpty();
    }

    @Override
    public void traverse(AnnotationVisitor visitor) {
        if (visitor.visit(this)) {
            for (Annotation a : this.annotations) {
                a.traverse(visitor);
            }
        }
        visitor.endVisit(this);
    }
}

