/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.doctrine.annotation.model;

import com.dubture.doctrine.annotation.model.AnnotationSourceElement;
import com.dubture.doctrine.annotation.model.AnnotationVisitor;
import java.util.Stack;

public class AnnotationClass
extends AnnotationSourceElement {
    protected String className = "";
    protected Stack<String> namespace = new Stack();

    public String getClassName() {
        return this.className;
    }

    public String getFullyQualifiedName() {
        return String.valueOf(this.getNamespace()) + this.getClassName();
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getNamespace() {
        StringBuilder namespaceBuilder = new StringBuilder();
        for (String part : this.namespace) {
            namespaceBuilder.append(part);
            namespaceBuilder.append('\\');
        }
        return namespaceBuilder.toString();
    }

    public boolean hasNamespace() {
        return !this.namespace.isEmpty();
    }

    public String getFirstNamespacePart() {
        if (this.namespace.size() > 0) {
            return (String)this.namespace.get(0);
        }
        return null;
    }

    public void pushNamespaceSegment(String namespaceSegment) {
        this.namespace.push(namespaceSegment);
    }

    @Override
    public void traverse(AnnotationVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }
}

