/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.doctrine.annotation.model;

import com.dubture.doctrine.annotation.model.AnnotationSourceElement;
import com.dubture.doctrine.annotation.model.AnnotationVisitor;
import com.dubture.doctrine.annotation.model.Argument;
import com.dubture.doctrine.annotation.model.IArgumentValue;
import com.dubture.doctrine.annotation.model.NamedArgument;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AnnotationDeclaration
extends AnnotationSourceElement {
    protected List<Argument> arguments = new LinkedList<Argument>();

    public List<Argument> getArguments() {
        return this.arguments;
    }

    public Map<String, NamedArgument> getNamedArguments() {
        HashMap<String, NamedArgument> namedArguments = new HashMap<String, NamedArgument>();
        for (Argument argument : this.arguments) {
            if (!(argument instanceof NamedArgument)) continue;
            NamedArgument namedArgument = (NamedArgument)argument;
            namedArguments.put(namedArgument.getName(), namedArgument);
        }
        return namedArguments;
    }

    public void addArgument(Argument argument) {
        this.arguments.add(argument);
    }

    public void addArgument(String name, IArgumentValue value) {
        this.arguments.add(new NamedArgument(name, value));
    }

    public boolean hasArgument(int index) {
        return index >= 0 && index < this.arguments.size();
    }

    public String getArgument(int index) {
        if (index < 0 || index >= this.arguments.size()) {
            return null;
        }
        return this.arguments.get(index).getValue().toString();
    }

    public String getArgument(String name) {
        IArgumentValue argumentValue = this.getArgumentValue(name);
        if (argumentValue == null) {
            return null;
        }
        return argumentValue.toString();
    }

    public IArgumentValue getArgumentValue(int index) {
        if (index < 0 || index >= this.arguments.size()) {
            return null;
        }
        return this.arguments.get(index).getValue();
    }

    public IArgumentValue getArgumentValue(String name) {
        for (Argument argument : this.arguments) {
            NamedArgument namedArgument;
            if (!(argument instanceof NamedArgument) || !(namedArgument = (NamedArgument)argument).getName().equals(name)) continue;
            return namedArgument.getValue();
        }
        return null;
    }

    public String toString() {
        return "(" + this.arguments.toString() + ")";
    }

    @Override
    public void traverse(AnnotationVisitor visitor) {
        if (visitor.visit(this)) {
            for (Argument a : this.arguments) {
                a.traverse(visitor);
            }
        }
        visitor.endVisit(this);
    }
}

