/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.doctrine.annotation.model;

import com.dubture.doctrine.annotation.model.AnnotationVisitor;
import com.dubture.doctrine.annotation.model.ArgumentValue;
import com.dubture.doctrine.annotation.model.ArgumentValueType;
import com.dubture.doctrine.annotation.model.IArgumentValue;
import java.util.LinkedList;
import java.util.List;

public class ArrayValue
extends ArgumentValue {
    private List<IArgumentValue> values = new LinkedList<IArgumentValue>();

    public void add(IArgumentValue value) {
        this.values.add(value);
    }

    public Object get(int index) {
        if (index >= 0 && index < this.values.size()) {
            return this.values.get(index).getValue();
        }
        return null;
    }

    public IArgumentValue getArgumentValue(int index) {
        if (index >= 0 && index < this.values.size()) {
            return this.values.get(index);
        }
        return null;
    }

    @Override
    public Object getValue() {
        return this.values;
    }

    @Override
    public ArgumentValueType getType() {
        return ArgumentValueType.ARRAY;
    }

    public String toString() {
        return this.values.toString();
    }

    @Override
    public void traverse(AnnotationVisitor visitor) {
        if (visitor.visit(this)) {
            for (IArgumentValue val : this.values) {
                val.traverse(visitor);
            }
        }
        visitor.endVisit(this);
    }
}

