/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.doctrine.annotation.parser;

import com.dubture.doctrine.annotation.model.Annotation;
import com.dubture.doctrine.annotation.model.AnnotationBlock;
import com.dubture.doctrine.annotation.parser.antlr.AnnotationLexer;
import com.dubture.doctrine.annotation.parser.antlr.AnnotationParser;
import com.dubture.doctrine.annotation.parser.antlr.SourcePosition;
import com.dubture.doctrine.annotation.parser.antlr.error.IAnnotationErrorReporter;
import com.dubture.doctrine.annotation.parser.tree.AnnotationCommonTree;
import com.dubture.doctrine.annotation.parser.tree.AnnotationCommonTreeAdaptor;
import com.dubture.doctrine.annotation.parser.tree.visitor.AnnotationNodeVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.TreeAdaptor;

public class AnnotationCommentParser {
    protected StringBuffer buffer;
    protected List<String> includedClassNames;
    protected List<String> excludedClassNames;
    protected String currentChunk;
    protected int lineOffset;
    protected int columnOffset;
    protected int currentCharOffset;
    protected int commentCharOffset;

    public static AnnotationBlock parseFromString(String comment) {
        return AnnotationCommentParser.parseFromString(comment, 0);
    }

    public static AnnotationBlock parseFromString(String comment, int commentCharOffset) {
        return AnnotationCommentParser.parseFromString(comment, 0, new ArrayList<String>());
    }

    public static AnnotationBlock parseFromString(String comment, int commentCharOffset, List<String> excludedClassNames) {
        return AnnotationCommentParser.parseFromString(comment, commentCharOffset, excludedClassNames);
    }

    public static AnnotationBlock parseFromString(String comment, int commentCharOffset, List<String> excludedClassNames, List<String> includedClassNames) {
        AnnotationCommentParser parser = new AnnotationCommentParser(excludedClassNames, includedClassNames);
        return parser.parse(comment, commentCharOffset);
    }

    public AnnotationCommentParser() {
        this(new ArrayList<String>());
    }

    public AnnotationCommentParser(List<String> excludedClassNames) {
        this(excludedClassNames, new ArrayList<String>());
    }

    public AnnotationCommentParser(List<String> excludedClassNames, List<String> includedClassNames) {
        this.excludedClassNames = excludedClassNames;
        this.includedClassNames = new LinkedList<String>();
    }

    public void addIncludedClassName(String className) {
        this.includedClassNames.add(className);
    }

    public void addIncludedClassNames(String[] classNames) {
        this.includedClassNames.addAll(Arrays.asList(classNames));
    }

    public void addExcludedClassName(String className) {
        this.excludedClassNames.add(className);
    }

    public void addExcludedClassNames(String[] classNames) {
        this.excludedClassNames.addAll(Arrays.asList(classNames));
    }

    public void setIncludedClassNames(String[] classNames) {
        this.includedClassNames = Arrays.asList(classNames);
    }

    public void setExcludedClassNames(String[] classNames) {
        this.excludedClassNames = Arrays.asList(classNames);
    }

    protected void reset(String comment, int commentCharOffset) {
        this.buffer = new StringBuffer(comment);
        this.lineOffset = 0;
        this.columnOffset = 0;
        this.currentCharOffset = 0;
        this.commentCharOffset = commentCharOffset;
    }

    public AnnotationBlock parse(String comment) {
        return this.parse(comment, 0);
    }

    public AnnotationBlock parse(String comment, int commentCharOffset) {
        this.reset(comment, commentCharOffset);
        LinkedList<Annotation> annotations = new LinkedList<Annotation>();
        while (this.hasMoreChunk()) {
            this.currentChunk = this.getNextChunk();
            Annotation annotation = this.parseChunk(this.currentChunk);
            if (!this.isValidAnnotation(annotation)) {
                ++this.currentCharOffset;
                continue;
            }
            annotations.add(annotation);
            this.currentCharOffset = annotation.getSourcePosition().endOffset + 1 - commentCharOffset;
        }
        return this.prepareBlock(this.postProcess(annotations));
    }

    protected boolean isValidAnnotation(Annotation annotation) {
        if (annotation == null || annotation.getSourcePosition().endOffset == -1) {
            return false;
        }
        int lastCharOffset = annotation.getSourcePosition().endOffset - this.currentCharOffset - this.commentCharOffset;
        if (lastCharOffset < 0 || lastCharOffset + 1 > this.currentChunk.length()) {
            return false;
        }
        if (lastCharOffset + 1 == this.currentChunk.length()) {
            return true;
        }
        return Character.isWhitespace(this.currentChunk.codePointAt(lastCharOffset + 1));
    }

    protected List<Annotation> postProcess(List<Annotation> annotations) {
        boolean hasExcludeRestriction;
        boolean hasIncludeRestriction = this.includedClassNames != null && this.includedClassNames.size() > 0;
        boolean bl = hasExcludeRestriction = this.excludedClassNames != null && this.excludedClassNames.size() > 0;
        if (!hasIncludeRestriction && !hasExcludeRestriction) {
            return annotations;
        }
        Iterator<Annotation> iterator = annotations.iterator();
        while (iterator.hasNext()) {
            Annotation annotation = iterator.next();
            String fullyQualifiedName = annotation.getFullyQualifiedName();
            if (!hasExcludeRestriction || !this.excludedClassNames.contains(fullyQualifiedName)) continue;
            iterator.remove();
        }
        return annotations;
    }

    protected AnnotationBlock prepareBlock(List<Annotation> annotations) {
        AnnotationBlock block = new AnnotationBlock(annotations);
        if (!annotations.isEmpty()) {
            Annotation first = annotations.get(0);
            Annotation last = annotations.get(annotations.size() - 1);
            block.setSourcePosition(new SourcePosition(first.getSourcePosition().line, first.getSourcePosition().column, first.getSourcePosition().startOffset, last.getSourcePosition().endOffset));
        }
        return block;
    }

    protected Annotation parseChunk(String chunk) {
        ANTLRStringStream content = new ANTLRStringStream(chunk);
        AnnotationLexer lexer = new AnnotationLexer((CharStream)content, new IAnnotationErrorReporter(){

            @Override
            public void reportError(String header, String message, RecognitionException e) {
            }
        });
        AnnotationParser parser = new AnnotationParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.setTreeAdaptor((TreeAdaptor)new AnnotationCommonTreeAdaptor());
        Annotation annotation = null;
        try {
            AnnotationParser.annotation_return root = parser.annotation();
            AnnotationCommonTree tree = (AnnotationCommonTree)((Object)root.getTree());
            AnnotationNodeVisitor visitor = new AnnotationNodeVisitor(this.lineOffset, this.columnOffset, this.currentCharOffset + this.commentCharOffset);
            tree.accept(visitor);
            annotation = visitor.getAnnotation();
        }
        catch (RecognitionException exception) {
            exception.printStackTrace();
        }
        return annotation;
    }

    protected boolean hasMoreChunk() {
        if (this.currentCharOffset >= this.buffer.length()) {
            return false;
        }
        int atSignIndex = this.buffer.indexOf("@", this.currentCharOffset);
        return atSignIndex != -1 && atSignIndex < this.buffer.length() - 1;
    }

    protected String getNextChunk() {
        int oldOffset = this.currentCharOffset;
        this.currentCharOffset = this.buffer.indexOf("@", this.currentCharOffset);
        String newChunk = this.buffer.substring(this.currentCharOffset);
        String oldChunk = this.buffer.substring(oldOffset, this.currentCharOffset);
        this.adjustOffset(oldChunk);
        return newChunk;
    }

    protected void adjustOffset(String oldChunk) {
        Matcher matcher = Pattern.compile("\r\n|\n|\r").matcher(oldChunk);
        int lastMatchEnd = -1;
        while (matcher.find()) {
            ++this.lineOffset;
            lastMatchEnd = matcher.end() - 1;
        }
        this.columnOffset = oldChunk.length() - lastMatchEnd;
    }
}

