/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.doctrine.annotation.parser.antlr;

import com.dubture.doctrine.annotation.parser.antlr.AnnotationToken;

public class SourcePosition {
    public int line;
    public int column;
    public int startOffset;
    public int endOffset;
    public int length;

    public static SourcePosition fromToken(AnnotationToken token) {
        SourcePosition position = new SourcePosition();
        position.setToken(token);
        return position;
    }

    public static SourcePosition fromStartEndToken(AnnotationToken startToken, AnnotationToken endToken) {
        return new SourcePosition(startToken, endToken);
    }

    public SourcePosition() {
        this(-1, -1, -1, -1);
    }

    public SourcePosition(int line, int column, int startOffset) {
        this.line = line;
        this.column = column;
        this.startOffset = startOffset;
    }

    public SourcePosition(int startLine, int startColumn, int startOffset, int endOffset) {
        this.line = startLine;
        this.column = startColumn;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.length = endOffset - startOffset + 1;
    }

    public SourcePosition(AnnotationToken startToken) {
        this(startToken.getLine(), startToken.getColumn(), startToken.getStartOffset());
    }

    public SourcePosition(AnnotationToken startToken, AnnotationToken endToken) {
        this(startToken.getLine(), startToken.getColumn(), startToken.getStartOffset(), endToken.getEndOffset());
    }

    public void set(int startLine, int startColumn, int startOffset, int endOffset) {
        this.line = startLine;
        this.column = startColumn;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.length = endOffset - startOffset + 1;
    }

    public void set(AnnotationToken startToken, AnnotationToken endToken) {
        this.set(startToken.getLine(), startToken.getColumn(), startToken.getStartOffset(), endToken.getEndOffset());
    }

    public void setStart(int line, int column, int startOffset) {
        this.line = line;
        this.column = column;
        this.startOffset = startOffset;
    }

    public void setStart(AnnotationToken startToken) {
        this.setStart(startToken.getLine(), startToken.getColumn(), startToken.getStartOffset());
    }

    public void setEnd(int endOffset) {
        this.endOffset = endOffset;
        this.length = endOffset - this.startOffset + 1;
    }

    public void setEnd(AnnotationToken endToken) {
        this.setEnd(endToken.getEndOffset());
    }

    public void setToken(AnnotationToken token) {
        this.setStart(token);
        this.setEnd(token);
    }

    public String toString() {
        return "<" + this.line + ", " + this.column + ">(" + this.startOffset + ", " + this.endOffset + ")";
    }
}

