/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.doctrine.annotation.parser.tree.visitor;

import com.dubture.doctrine.annotation.model.Annotation;
import com.dubture.doctrine.annotation.model.Argument;
import com.dubture.doctrine.annotation.model.IArgumentValue;
import com.dubture.doctrine.annotation.parser.tree.AnnotationCommonTree;
import com.dubture.doctrine.annotation.parser.tree.visitor.AbstractAnnotationNodeVisitor;
import java.util.Arrays;
import java.util.LinkedList;
import org.eclipse.dltk.core.builder.IBuildContext;

public class AnnotationNodeVisitor
extends AbstractAnnotationNodeVisitor {
    protected Annotation annotation = new Annotation();

    public AnnotationNodeVisitor() {
    }

    public AnnotationNodeVisitor(int lineOffset, int columnOffset, int charOffset) {
        AnnotationCommonTree.lineOffset = lineOffset;
        AnnotationCommonTree.columnOffset = columnOffset;
        AnnotationCommonTree.charOffset = charOffset;
    }

    public AnnotationNodeVisitor(IBuildContext context) {
    }

    @Override
    public void visit(AnnotationCommonTree node) {
        if (node.isNil()) {
            this.annotation = null;
            return;
        }
        this.visitClass(node.getChild(0));
        if (node.getChildCount() > 1) {
            this.visitDeclaration(node.getChild(1));
        } else {
            this.annotation.getSourcePosition().setEnd(node.getChild(0).getToken());
        }
    }

    protected void visitClass(AnnotationCommonTree classNode) {
        this.annotation.getSourcePosition().setStart(classNode.getToken());
        this.annotation.getAnnotationClass().getSourcePosition().setToken(classNode.getToken());
        String fullyQualifiedClass = classNode.getText().substring(1);
        LinkedList<String> namespaceSegments = new LinkedList<String>(Arrays.asList(fullyQualifiedClass.split("\\\\")));
        String className = (String)namespaceSegments.remove(namespaceSegments.size() - 1);
        this.annotation.setClassName(className);
        for (String namespaceSegment : namespaceSegments) {
            this.annotation.pushNamespaceSegment(namespaceSegment);
        }
    }

    protected void visitDeclaration(AnnotationCommonTree declarationNode) {
        if (declarationNode.getChildCount() == 0) {
            return;
        }
        for (AnnotationCommonTree childNode : declarationNode.getChildTrees()) {
            switch (childNode.getType()) {
                case 19: {
                    this.annotation.getDeclaration().getSourcePosition().setStart(childNode.getToken());
                    break;
                }
                case 36: {
                    this.visitArgument(childNode);
                    break;
                }
                case 43: {
                    this.visitNamedArgument(childNode);
                    break;
                }
                case 20: {
                    this.annotation.getSourcePosition().setEnd(childNode.getToken());
                    this.annotation.getDeclaration().getSourcePosition().setEnd(childNode.getToken());
                    break;
                }
            }
        }
    }

    protected void visitArgument(AnnotationCommonTree argumentNode) {
        IArgumentValue argumentValue = this.visitArgumentValue(argumentNode.getChild(0));
        this.annotation.addArgument(new Argument(argumentValue));
    }

    protected void visitNamedArgument(AnnotationCommonTree namedArgumentNode) {
        AnnotationCommonTree argumentNameNode = namedArgumentNode.getFirstChildFromType(37);
        String name = argumentNameNode.getChild(0).getText();
        AnnotationCommonTree argumentValueNode = namedArgumentNode.getFirstChildFromType(38);
        IArgumentValue argumentValue = null;
        if (argumentValueNode != null && argumentValueNode.getChildCount() > 0) {
            argumentValue = this.visitArgumentValue(argumentValueNode.getChild(0));
        }
        this.annotation.addArgument(name, argumentValue);
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }
}

