/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.doctrine.core;

import com.dubture.doctrine.core.DoctrineCorePlugin;
import com.dubture.doctrine.core.compiler.IAnnotationModuleDeclaration;
import com.dubture.doctrine.internal.core.compiler.AnnotationParser;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.parser.IModuleDeclaration;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.compiler.problem.ProblemCollector;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceModuleInfoCache;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.php.core.compiler.ast.nodes.PHPModuleDeclaration;

public class AnnotationParserUtil {
    private static final String MODULE_KEY = "_annotations";
    private static final String ERRORS_KEY = "_annotation_errors";

    public static IAnnotationModuleDeclaration getModule(ISourceModule module) throws CoreException {
        return AnnotationParserUtil.getModule(module, null);
    }

    public static IAnnotationModuleDeclaration getModule(ISourceModule module, IProblemReporter reporter) throws CoreException {
        IAnnotationModuleDeclaration moduleDeclaration = null;
        ISourceModuleInfoCache.ISourceModuleInfo mifo = SourceParserUtil.getCache().get(module);
        if (mifo != null && (moduleDeclaration = (IAnnotationModuleDeclaration)mifo.get(MODULE_KEY)) != null) {
            ProblemCollector collector;
            if (reporter != null && (collector = (ProblemCollector)mifo.get(ERRORS_KEY)) != null) {
                collector.copyTo(reporter);
            }
            return moduleDeclaration;
        }
        ModuleDeclaration md = SourceParserUtil.getModuleDeclaration((ISourceModule)module, (IProblemReporter)reporter);
        if (!(md instanceof PHPModuleDeclaration)) {
            return null;
        }
        AnnotationParser annotationParser = new AnnotationParser();
        try {
            ProblemCollector collector = new ProblemCollector();
            moduleDeclaration = annotationParser.parse(module, (IModuleDeclaration)md, (IProblemReporter)collector);
            AnnotationParserUtil.putModuleToCache(mifo, moduleDeclaration, collector);
            if (reporter != null) {
                collector.copyTo((IProblemReporter)collector);
            }
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, DoctrineCorePlugin.ID, "Problem during parse", (Throwable)e));
        }
        return moduleDeclaration;
    }

    public static IAnnotationModuleDeclaration getModuleFromCache(ISourceModuleInfoCache.ISourceModuleInfo mifo, IProblemReporter reporter) {
        if (mifo != null) {
            ProblemCollector collector;
            IAnnotationModuleDeclaration moduleDeclaration = (IAnnotationModuleDeclaration)mifo.get(MODULE_KEY);
            if (moduleDeclaration != null && reporter != null && (collector = (ProblemCollector)mifo.get(ERRORS_KEY)) != null) {
                collector.copyTo(reporter);
            }
            return moduleDeclaration;
        }
        return null;
    }

    public static void putModuleToCache(ISourceModuleInfoCache.ISourceModuleInfo info, IAnnotationModuleDeclaration module, ProblemCollector collector) {
        info.put(MODULE_KEY, (Object)module);
        if (collector != null && !collector.isEmpty()) {
            info.put(ERRORS_KEY, (Object)collector);
        } else {
            info.remove(ERRORS_KEY);
        }
    }
}

