/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.doctrine.core;

import com.dubture.doctrine.core.DoctrineNature;
import com.dubture.doctrine.core.log.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public class DoctrineCorePlugin
extends Plugin {
    private static BundleContext context;
    public static String ID;
    private static DoctrineCorePlugin plugin;
    private static final String isDebugMode = "com.dubture.symfony.core/debug";

    static {
        ID = "com.dubture.doctrine.core";
    }

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        context = bundleContext;
        plugin = this;
        new Job("Doctrine index change detector"){

            protected IStatus run(IProgressMonitor monitor) {
                IEclipsePreferences node = InstanceScope.INSTANCE.getNode(ID);
                if (!"0.0.7".equals(node.get("indexVersion", null))) {
                    try {
                        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                        int n = iProjectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProject project = iProjectArray[n2];
                            if (project.isAccessible() && project.hasNature(DoctrineNature.NATURE_ID)) {
                                monitor.subTask("Rebuild doctrine index: " + project.getName());
                                project.build(15, monitor);
                            }
                            ++n2;
                        }
                        node.put("indexVersion", "0.0.7");
                        node.flush();
                    }
                    catch (BackingStoreException e) {
                        Logger.logException(e);
                    }
                    catch (CoreException e) {
                        Logger.logException(e);
                    }
                }
                return Status.OK_STATUS;
            }
        }.schedule(100L);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
        plugin = null;
        super.stop(bundleContext);
    }

    public static boolean debug() {
        String debugOption = Platform.getDebugOption((String)isDebugMode);
        return DoctrineCorePlugin.getDefault().isDebugging() && "true".equalsIgnoreCase(debugOption);
    }

    private static DoctrineCorePlugin getDefault() {
        return plugin;
    }
}

