/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.doctrine.core.codeassist;

import com.dubture.doctrine.core.DoctrineNature;
import com.dubture.doctrine.core.log.Logger;
import com.dubture.doctrine.internal.core.text.PHPDocTextSequenceUtilities;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.codeassist.ScriptSelectionEngine;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.core.compiler.ast.nodes.PHPModuleDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.model.PHPModelAccess;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class DoctrineSelectionEngine
extends ScriptSelectionEngine {
    private static final IModelElement[] NONE = new IModelElement[0];
    private static final String DEFAULT_ANNOTATION_QUALIFIER = "Doctrine\\Common\\Annotations\\Annotation";

    public IModelElement[] select(IModuleSource sourceUnit, int offset, int end) {
        IStructuredDocument document;
        ISourceModule sourceModule;
        block19: {
            if (!PHPCorePlugin.toolkitInitialized) {
                return NONE;
            }
            if (end < offset) {
                end = offset + 1;
            }
            sourceModule = (ISourceModule)sourceUnit.getModelElement();
            try {
                if (sourceModule == null || !sourceModule.getScriptProject().getProject().hasNature(DoctrineNature.NATURE_ID)) {
                    return NONE;
                }
            }
            catch (CoreException e) {
                Logger.logException(e);
                return NONE;
            }
            String content = sourceUnit.getSourceContents();
            if (content.length() <= offset) {
                return NONE;
            }
            document = null;
            IStructuredModel structuredModel = null;
            try {
                try {
                    IFile file = (IFile)sourceUnit.getModelElement().getResource();
                    if (file != null) {
                        if (file.exists()) {
                            structuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(file);
                            document = structuredModel != null ? structuredModel.getStructuredDocument() : StructuredModelManager.getModelManager().createStructuredDocumentFor(file);
                        } else {
                            document = StructuredModelManager.getModelManager().createNewStructuredDocumentFor(file);
                            document.set(sourceUnit.getSourceContents());
                        }
                    }
                }
                catch (Exception e) {
                    Logger.logException(e);
                    if (structuredModel != null) {
                        structuredModel.releaseFromRead();
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                if (structuredModel != null) {
                    structuredModel.releaseFromRead();
                }
                throw throwable;
            }
            if (structuredModel != null) {
                structuredModel.releaseFromRead();
            }
        }
        if (document == null) {
            return NONE;
        }
        if (PHPDocTextSequenceUtilities.isPHPDoc(document, offset)) {
            return this.phpDocRead(sourceModule, document, offset, end);
        }
        return NONE;
    }

    private IModelElement[] phpDocRead(ISourceModule sourceModule, IStructuredDocument document, int offset, int end) {
        try {
            char next;
            PHPModuleDeclaration moduleDeclaration = (PHPModuleDeclaration)SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
            if (moduleDeclaration == null) {
                return NONE;
            }
            String annotationName = PHPDocTextSequenceUtilities.getAnnotationName((IDocument)document, offset, end);
            if (annotationName != null) {
                String name = annotationName;
                String qualifier = null;
                IType namespace = PHPModelUtils.getCurrentNamespace((ISourceModule)sourceModule, (int)offset);
                if (annotationName.contains(String.valueOf('\\'))) {
                    int i = name.lastIndexOf(92);
                    qualifier = name.substring(0, i);
                    name = name.substring(i + 1);
                    String alias = qualifier;
                    i = qualifier.indexOf(92);
                    if (i != -1) {
                        alias = qualifier.substring(0, i);
                    }
                    Map aliases = PHPModelUtils.getAliasToNSMap((String)alias, (ModuleDeclaration)moduleDeclaration, (int)offset, (IType)namespace, (boolean)true);
                    for (Map.Entry entry : aliases.entrySet()) {
                        if (!alias.equalsIgnoreCase((String)entry.getKey())) continue;
                        qualifier = ((UsePart)entry.getValue()).getNamespace().getFullyQualifiedName();
                        break;
                    }
                } else {
                    Map map = PHPModelUtils.getAliasToNSMap((String)annotationName, (ModuleDeclaration)moduleDeclaration, (int)offset, (IType)namespace, (boolean)false);
                    for (Map.Entry entry : map.entrySet()) {
                        if (!annotationName.equalsIgnoreCase((String)entry.getKey())) continue;
                        qualifier = ((UsePart)entry.getValue()).getNamespace().getNamespace().getName();
                        name = ((UsePart)entry.getValue()).getNamespace().getName();
                        break;
                    }
                }
                IDLTKSearchScope scope = this.createSearchScope(sourceModule);
                if (qualifier == null) {
                    qualifier = DEFAULT_ANNOTATION_QUALIFIER;
                }
                if (document.getChar(end + 1) == '\\') {
                    StringBuilder sb = new StringBuilder(qualifier);
                    sb.append('\\').append(name);
                    return PHPModelAccess.getDefault().findTypes(null, sb.toString(), ISearchEngine.MatchRule.EXACT, 2048, 0, scope, null);
                }
                return PHPModelAccess.getDefault().findTypes(qualifier, name, ISearchEngine.MatchRule.EXACT, 0, 0, scope, null);
            }
            String text = document.getText();
            int nameStart = PHPTextSequenceUtilities.readNamespaceStartIndex((CharSequence)text, (int)offset, (boolean)false);
            int nameEnd = PHPTextSequenceUtilities.readNamespaceEndIndex((CharSequence)text, (int)offset, (boolean)false);
            if (nameStart > 0 && nameStart < nameEnd && (next = text.charAt(PHPTextSequenceUtilities.readForwardSpaces((CharSequence)text, (int)nameEnd))) != '=') {
                String name = text.substring(nameStart, nameEnd);
                if (nameStart + name.lastIndexOf(92) > offset) {
                    name = name.substring(0, name.lastIndexOf(92));
                    return PHPModelAccess.getDefault().findNamespaces(null, name, ISearchEngine.MatchRule.EXACT, 0, 0, this.createSearchScope(sourceModule), null);
                }
                return PHPModelAccess.getDefault().findTypes(name, ISearchEngine.MatchRule.EXACT, 0, 0, this.createSearchScope(sourceModule), null);
            }
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
        return NONE;
    }

    private IDLTKSearchScope createSearchScope(ISourceModule sourceModule) {
        if (sourceModule.getScriptProject() != null) {
            return SearchEngine.createSearchScope((IModelElement)sourceModule.getScriptProject());
        }
        IProjectFragment projectFragment = (IProjectFragment)sourceModule.getAncestor(3);
        if (projectFragment != null) {
            return SearchEngine.createSearchScope((IModelElement)projectFragment);
        }
        return SearchEngine.createSearchScope((IModelElement)sourceModule);
    }
}

