/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.doctrine.core.codeassist.contexts;

import com.dubture.doctrine.core.DoctrineNature;
import com.dubture.doctrine.core.log.Logger;
import com.dubture.doctrine.internal.core.text.PHPDocTextSequenceUtilities;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.internal.core.codeassist.contexts.PHPDocTagContext;
import org.eclipse.php.internal.core.util.text.TextSequence;

public abstract class AnnotationBodyContext
extends PHPDocTagContext {
    private String annotationName;

    protected boolean detectEnvironment(TextSequence sequence, int offset) {
        if ((offset = PHPDocTextSequenceUtilities.findAnnotationBodyStart(sequence, offset)) == -1) {
            return false;
        }
        offset = PHPDocTextSequenceUtilities.readBackwardSpaces(sequence, offset);
        StringBuilder name = new StringBuilder();
        while (offset >= 0) {
            char ch = sequence.charAt(offset);
            if (PHPDocTextSequenceUtilities.isIdentPart(ch)) {
                name.insert(0, ch);
            } else if (ch == '@') {
                if (name.length() == 0) {
                    return false;
                }
                this.annotationName = name.toString();
                return true;
            }
            --offset;
        }
        return false;
    }

    public boolean isValid(ISourceModule sourceModule, int offset, CompletionRequestor requestor) {
        block4: {
            if (!super.isValid(sourceModule, offset, requestor)) {
                return false;
            }
            try {
                if (sourceModule.getScriptProject().getProject().hasNature(DoctrineNature.NATURE_ID)) break block4;
                return false;
            }
            catch (Exception e) {
                Logger.logException(e);
                return false;
            }
        }
        TextSequence sequence = this.getStatementText();
        return this.detectEnvironment(sequence, sequence.length() - 1);
    }

    public String getAnnotationName() {
        return this.annotationName;
    }
}

