/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.doctrine.core.codeassist.contexts;

import com.dubture.doctrine.core.DoctrineNature;
import com.dubture.doctrine.core.log.Logger;
import com.dubture.doctrine.internal.core.text.PHPDocTextSequenceUtilities;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.internal.core.codeassist.contexts.PHPDocTagContext;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPHPScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class AnnotationCompletionContext
extends PHPDocTagContext {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValid(ISourceModule sourceModule, int offset, CompletionRequestor requestor) {
        if (!super.isValid(sourceModule, offset, requestor)) {
            return false;
        }
        try {
            if (!sourceModule.getScriptProject().getProject().hasNature(DoctrineNature.NATURE_ID)) {
                return false;
            }
            TextSequence sequence = this.getStatementText();
            int start = sequence.toString().lastIndexOf("@");
            int end = sequence.toString().length();
            String line = sequence.toString().substring(start, end);
            if (line.contains("(") || line.contains("[") || line.contains("{") || line.contains(" ") || line.contains("\t")) {
                return false;
            }
            if ((line = line.trim()).trim().endsWith("*")) {
                return false;
            }
            int i = line.length() - 1;
            while (true) {
                if (i <= 0) {
                    return true;
                }
                char ch = line.charAt(i);
                if (!PHPDocTextSequenceUtilities.isIdentPart(ch)) {
                    return false;
                }
                --i;
            }
        }
        catch (Exception e) {
            Logger.logException(e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getTarget() {
        int offset = this.getCompanion().getOffset();
        IStructuredDocumentRegion sdRegion = this.getCompanion().getDocument().getRegionAtCharacterOffset(offset);
        ITextRegion textRegion = sdRegion.getRegionAtCharacterOffset(offset);
        if (!(textRegion instanceof IPHPScriptRegion)) {
            return -1;
        }
        IPHPScriptRegion phpScriptRegion = (IPHPScriptRegion)textRegion;
        int position = offset;
        try {
            textRegion = phpScriptRegion.getPHPToken(position - phpScriptRegion.getStart() - sdRegion.getStartOffset());
            if (textRegion != null && PHPDocTextSequenceUtilities.isInsideAnnotation(sdRegion.getParentDocument().get(textRegion.getStart(), textRegion.getEnd() + sdRegion.getStartOffset() > offset ? textRegion.getEnd() + sdRegion.getStartOffset() : offset), offset - textRegion.getStart())) {
                return 0x2000000;
            }
            while (true) {
                if (textRegion == null) {
                    return -1;
                }
                if (PHPPartitionTypes.isPHPCommentState((String)textRegion.getType()) || "WHITESPACE".equals(textRegion.getType())) {
                    textRegion = phpScriptRegion.getPHPToken(textRegion.getEnd() + 1);
                    continue;
                }
                if ("PHP_CURLY_OPEN".equals(textRegion.getType())) return -1;
                if ("PHP_SEMICOLON".equals(textRegion.getType())) {
                    return -1;
                }
                if ("PHP_FUNCTION".equals(textRegion.getType())) {
                    return 0x10000000;
                }
                if ("PHP_VAR".equals(textRegion.getType())) {
                    return 0x4000000;
                }
                if ("PHP_VARIABLE".equals(textRegion.getType())) {
                    return 0x4000000;
                }
                if ("PHP_CLASS".equals(textRegion.getType())) {
                    return 16384;
                }
                textRegion = phpScriptRegion.getPHPToken(textRegion.getEnd() + 1);
            }
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
        return -1;
    }
}

