/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.doctrine.core.codeassist.contexts;

import com.dubture.doctrine.core.codeassist.contexts.AnnotationBodyContext;
import com.dubture.doctrine.core.log.Logger;
import com.dubture.doctrine.internal.core.text.PHPDocTextSequenceUtilities;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;

public class AnnotationFieldValueContext
extends AnnotationBodyContext {
    private String fieldName;
    private String valuePrefix;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isValid(ISourceModule sourceModule, int offset, CompletionRequestor requestor) {
        if (!super.isValid(sourceModule, offset, requestor)) {
            return false;
        }
        try {
            TextSequence sequence = this.getStatementText();
            offset = sequence.length() - 1;
            offset = PHPDocTextSequenceUtilities.readBackwardSpaces(sequence, offset);
            int start = PHPTextSequenceUtilities.readIdentifierStartIndex((CharSequence)sequence, (int)offset, (boolean)false);
            int end = PHPDocTextSequenceUtilities.readBackwardSpaces(sequence, start) - 1;
            StringBuilder prefixBuilder = new StringBuilder();
            while (offset > 0) {
                char ch = sequence.charAt(offset);
                if (ch == '=') {
                    this.valuePrefix = prefixBuilder.toString();
                    break;
                }
                if (ch == '(') {
                    this.valuePrefix = prefixBuilder.toString();
                    this.fieldName = "value";
                    return true;
                }
                prefixBuilder.insert(0, ch);
                --offset;
            }
            end = PHPDocTextSequenceUtilities.readBackwardSpaces(sequence, offset);
            start = PHPTextSequenceUtilities.readIdentifierStartIndex((CharSequence)sequence, (int)offset, (boolean)false);
            if (start >= end) {
                return false;
            }
            this.fieldName = sequence.toString().substring(start, end);
            return true;
        }
        catch (Exception e) {
            Logger.logException(e);
            return false;
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getValuePrefix() {
        return this.valuePrefix;
    }
}

