/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.doctrine.core.codeassist.strategies;

import com.dubture.doctrine.core.codeassist.contexts.AnnotationCompletionContext;
import com.dubture.doctrine.core.compiler.DoctrineFlags;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.SourceType;
import org.eclipse.dltk.internal.core.hierarchy.FakeType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.ICompletionReporter;
import org.eclipse.php.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.codeassist.AliasType;
import org.eclipse.php.internal.core.codeassist.strategies.PHPDocTagStrategy;
import org.eclipse.php.internal.core.model.PHPModelAccess;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;

public class AnnotationCompletionStrategy
extends PHPDocTagStrategy {
    private int trueFlag = 4096;
    private int falseFlag = 0;

    public AnnotationCompletionStrategy(ICompletionContext context) {
        super(context);
    }

    public void apply(ICompletionReporter reporter) throws BadLocationException {
        String prefix;
        ICompletionContext ctx = this.getContext();
        if (!(ctx instanceof AnnotationCompletionContext)) {
            return;
        }
        AnnotationCompletionContext context = (AnnotationCompletionContext)ctx;
        int target = context.getTarget();
        if (target == -1) {
            return;
        }
        this.trueFlag = target;
        ISourceRange replaceRange = this.getReplacementRange((ICompletionContext)context);
        IDLTKSearchScope scope = this.createSearchScope();
        String name = prefix = context.getPrefix();
        String qualifier = null;
        ISourceModule sourceModule = this.getCompanion().getSourceModule();
        if (sourceModule == null) {
            return;
        }
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
        IType namespace = PHPModelUtils.getCurrentNamespace((ISourceModule)sourceModule, (int)this.getCompanion().getOffset());
        HashSet<IType> collected = new HashSet<IType>();
        if (prefix.contains(String.valueOf('\\'))) {
            int prefixEnd;
            int i = name.lastIndexOf(92);
            qualifier = name.substring(0, i);
            name = name.substring(i + 1);
            String alias = qualifier;
            i = qualifier.indexOf(92);
            if (i != -1) {
                alias = qualifier.substring(0, i);
            }
            int length = name.length();
            int start = this.getCompanion().getOffset() - length;
            if (start + length < (prefixEnd = context.getReplacementEnd())) {
                length = prefixEnd - start;
            }
            replaceRange = new SourceRange(start, length);
            Map aliases = PHPModelUtils.getAliasToNSMap((String)alias, (ModuleDeclaration)moduleDeclaration, (int)this.getCompanion().getOffset(), (IType)namespace, (boolean)false);
            for (Map.Entry entry : aliases.entrySet()) {
                if (!alias.equalsIgnoreCase((String)entry.getKey())) continue;
                qualifier = ((UsePart)entry.getValue()).getNamespace().getFullyQualifiedName();
                break;
            }
        } else {
            Map map = PHPModelUtils.getAliasToNSMap((String)"", (ModuleDeclaration)moduleDeclaration, (int)this.getCompanion().getOffset(), (IType)namespace, (boolean)false);
            for (Map.Entry entry : map.entrySet()) {
                if (!StringUtils.startsWithIgnoreCase((CharSequence)((CharSequence)entry.getKey()), (CharSequence)name)) continue;
                IType[] findTypes = PHPModelAccess.getDefault().findTypes(((UsePart)entry.getValue()).getNamespace().getFullyQualifiedName(), ISearchEngine.MatchRule.EXACT, 0, 0, scope, null);
                if (findTypes.length != 0) {
                    try {
                        int addon = 0;
                        String fullName = PHPModelUtils.getFullName((IType)findTypes[0]);
                        if ("Doctrine\\Common\\Annotations\\Annotation".equals(fullName) || "Doctrine\\Common\\Annotations\\Annotation".equals(qualifier)) {
                            addon = 512;
                        }
                        collected.add(findTypes[0]);
                        if (((String)entry.getKey()).equals(((UsePart)entry.getValue()).getNamespace().getName())) {
                            if (!DoctrineFlags.isAnnotation(findTypes[0].getFlags())) continue;
                            reporter.reportType(findTypes[0], "()", replaceRange, (Object)(2 | addon), 10000002);
                            continue;
                        }
                        reporter.reportType((IType)new AliasType((ModelElement)((SourceType)findTypes[0]), ((UsePart)entry.getValue()).getNamespace().getName(), (String)entry.getKey()), DoctrineFlags.isNamespace((int)findTypes[0].getFlags()) ? "\\" : "()", replaceRange, (Object)(2 | addon), 10000002);
                    }
                    catch (ModelException e) {
                        Logger.logException((Throwable)e);
                    }
                    continue;
                }
                reporter.reportType((IType)new FakeType((ModelElement)sourceModule, (String)entry.getKey(), 2048), "\\", replaceRange, (Object)(Integer.valueOf(2) | 0x200), 10000002);
            }
        }
        IType[] types = this.getTypes(context, scope, qualifier, name.trim());
        String suffix = "()";
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            if (!collected.contains(type)) {
                reporter.reportType(type, suffix, replaceRange, (Object)0, 10000001);
            }
            ++n2;
        }
    }

    private IType[] getTypes(AnnotationCompletionContext context, IDLTKSearchScope scope, String qualifier, String prefix) {
        IType[] types;
        if (context.getCompletionRequestor().isContextInformationMode()) {
            return PHPModelAccess.getDefault().findTypes(qualifier, prefix, ISearchEngine.MatchRule.EXACT, this.trueFlag, this.falseFlag, scope, null);
        }
        LinkedList<IType> result = new LinkedList<IType>();
        if (prefix.length() > 1 && prefix.toUpperCase().equals(prefix)) {
            types = PHPModelAccess.getDefault().findTypes(qualifier, prefix, ISearchEngine.MatchRule.CAMEL_CASE, this.trueFlag, this.falseFlag, scope, null);
            result.addAll(Arrays.asList(types));
        }
        types = PHPModelAccess.getDefault().findTypes(qualifier, prefix, ISearchEngine.MatchRule.PREFIX, this.trueFlag, this.falseFlag, scope, null);
        result.addAll(Arrays.asList(types));
        return result.toArray(new IType[result.size()]);
    }
}

