/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.doctrine.core.codeassist.strategies;

import com.dubture.doctrine.annotation.model.Annotation;
import com.dubture.doctrine.annotation.model.AnnotationBlock;
import com.dubture.doctrine.annotation.model.ArrayValue;
import com.dubture.doctrine.annotation.model.IArgumentValue;
import com.dubture.doctrine.annotation.model.StringValue;
import com.dubture.doctrine.core.AnnotationParserUtil;
import com.dubture.doctrine.core.codeassist.contexts.AnnotationFieldValueContext;
import com.dubture.doctrine.core.compiler.IAnnotationModuleDeclaration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.ICompletionReporter;
import org.eclipse.php.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.codeassist.IPHPCompletionRequestor;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.strategies.PHPDocTagStrategy;
import org.eclipse.php.internal.core.model.PHPModelAccess;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;

public class AnnotationEnumStrategy
extends PHPDocTagStrategy {
    private int trueFlag = 4096;
    private int falseFlag = 0;
    private static final Map<String, String[]> builtIn = new HashMap<String, String[]>();

    static {
        builtIn.put("Doctrine\\ORM\\Mapping\\Column#$type", new String[]{"smallint", "integer", "bigint", "decimal", "string", "text", "guid", "binary", "blob", "boolean", "date", "datetime", "datetimez", "time", "dateinterval", "array", "simple_array", "json_array", "object"});
        builtIn.put("Doctrine\\Common\\Annotations\\Annotation\\Target#$value", new String[]{"ALL", "CLASS", "METHOD", "PROPERTY", "ANNOTATION"});
    }

    public AnnotationEnumStrategy(ICompletionContext context) {
        super(context);
    }

    public void apply(ICompletionReporter reporter) throws BadLocationException {
        IType[] findTypes;
        String prefix;
        ICompletionContext ctx = this.getContext();
        if (!(ctx instanceof AnnotationFieldValueContext)) {
            return;
        }
        AnnotationFieldValueContext context = (AnnotationFieldValueContext)ctx;
        ISourceRange replaceRange = this.getReplacementRange((ICompletionContext)context);
        IDLTKSearchScope scope = this.createSearchScope();
        ISourceModule sourceModule = this.getCompanion().getSourceModule();
        if (sourceModule == null) {
            return;
        }
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
        IType namespace = PHPModelUtils.getCurrentNamespace((ISourceModule)sourceModule, (int)this.getCompanion().getOffset());
        String name = prefix = context.getAnnotationName();
        String qualifier = null;
        if (prefix.contains(String.valueOf('\\'))) {
            int prefixEnd;
            int i = name.lastIndexOf(92);
            qualifier = name.substring(0, i);
            name = name.substring(i + 1);
            String alias = qualifier;
            i = qualifier.indexOf(92);
            if (i != -1) {
                alias = qualifier.substring(0, i);
            }
            int length = name.length();
            int start = this.getCompanion().getOffset() - length;
            if (start + length < (prefixEnd = context.getReplacementEnd())) {
                length = prefixEnd - start;
            }
            Map aliases = PHPModelUtils.getAliasToNSMap((String)alias, (ModuleDeclaration)moduleDeclaration, (int)this.getCompanion().getOffset(), (IType)namespace, (boolean)false);
            for (Map.Entry entry : aliases.entrySet()) {
                if (!alias.equalsIgnoreCase((String)entry.getKey())) continue;
                qualifier = ((UsePart)entry.getValue()).getNamespace().getFullyQualifiedName();
                break;
            }
        } else {
            Map map = PHPModelUtils.getAliasToNSMap((String)"", (ModuleDeclaration)moduleDeclaration, (int)this.getCompanion().getOffset(), (IType)namespace, (boolean)false);
            for (Map.Entry entry : map.entrySet()) {
                if (!name.equalsIgnoreCase((String)entry.getKey())) continue;
                name = ((UsePart)entry.getValue()).getNamespace().getName();
                qualifier = ((UsePart)entry.getValue()).getNamespace().getNamespace().getName();
            }
            if (qualifier == null) {
                qualifier = "Doctrine\\Common\\Annotations\\Annotation";
            }
        }
        IType[] iTypeArray = findTypes = PHPModelAccess.getDefault().findTypes(qualifier, name, ISearchEngine.MatchRule.EXACT, this.trueFlag, this.falseFlag, scope, null);
        int n = findTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            try {
                IField[] iFieldArray = PHPModelUtils.getTypeHierarchyField((IType)type, (ITypeHierarchy)this.getCompanion().getSuperTypeHierarchy(type, null), (String)("$" + context.getFieldName()), (boolean)false, (IProgressMonitor)new NullProgressMonitor());
                int n3 = iFieldArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IField f = iFieldArray[n4];
                    this.collectValues(type, f, reporter, replaceRange, context);
                    ++n4;
                }
            }
            catch (ModelException e) {
                Logger.logException((Throwable)e);
            }
            catch (CoreException e) {
                Logger.logException((Throwable)e);
            }
            ++n2;
        }
    }

    private void collectValues(IType type, IField field, ICompletionReporter reporter, ISourceRange replaceRange, AnnotationFieldValueContext context) throws CoreException {
        String n = String.valueOf(PHPModelUtils.getFullName((IType)type)) + "#" + field.getElementName();
        IPHPCompletionRequestor phpCompletionRequestor = (IPHPCompletionRequestor)((AbstractCompletionContext)this.getContext()).getCompletionRequestor();
        if (builtIn.containsKey(n)) {
            phpCompletionRequestor.addFlag(2);
            String[] stringArray = builtIn.get(n);
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String key = stringArray[n3];
                if (StringUtils.startsWithIgnoreCase((CharSequence)key, (CharSequence)context.getValuePrefix())) {
                    reporter.reportKeyword(key, "", replaceRange);
                }
                ++n3;
            }
            return;
        }
        IAnnotationModuleDeclaration module = AnnotationParserUtil.getModule((ISourceModule)type.getAncestor(ISourceModule.class));
        if (module == null) {
            return;
        }
        AnnotationBlock annotations = module.readAnnotations((ISourceReference)field);
        for (Annotation ann : annotations.findAnnotations("Enum")) {
            phpCompletionRequestor.addFlag(2);
            IArgumentValue val = ann.getArgumentValue("value");
            if (val == null && ann.getArguments().size() > 0) {
                val = ann.getArgumentValue(0);
            }
            if (!(val instanceof ArrayValue)) continue;
            List arr = (List)val.getValue();
            for (IArgumentValue en : arr) {
                String string;
                if (!(en instanceof StringValue) || !StringUtils.startsWithIgnoreCase((CharSequence)(string = (String)en.getValue()), (CharSequence)context.getValuePrefix())) continue;
                reporter.reportKeyword(string, "", replaceRange);
            }
        }
    }
}

