/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.doctrine.core.codeassist.strategies;

import com.dubture.doctrine.core.codeassist.contexts.AnnotationFieldContext;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.ICompletionReporter;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.codeassist.strategies.PHPDocTagStrategy;
import org.eclipse.php.internal.core.model.PHPModelAccess;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;

public class AnnotationFieldStrategy
extends PHPDocTagStrategy {
    private int trueFlag = 4096;
    private int falseFlag = 0;

    public AnnotationFieldStrategy(ICompletionContext context) {
        super(context);
    }

    public void apply(ICompletionReporter reporter) throws BadLocationException {
        IType[] findTypes;
        String prefix;
        ICompletionContext ctx = this.getContext();
        if (!(ctx instanceof AnnotationFieldContext)) {
            return;
        }
        AnnotationFieldContext context = (AnnotationFieldContext)ctx;
        ISourceRange replaceRange = this.getReplacementRange((ICompletionContext)context);
        IDLTKSearchScope scope = this.createSearchScope();
        ISourceModule sourceModule = this.getCompanion().getSourceModule();
        if (sourceModule == null) {
            return;
        }
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
        IType namespace = PHPModelUtils.getCurrentNamespace((ISourceModule)sourceModule, (int)this.getCompanion().getOffset());
        String name = prefix = context.getAnnotationName();
        String qualifier = null;
        if (prefix.contains(String.valueOf('\\'))) {
            int prefixEnd;
            int i = name.lastIndexOf(92);
            qualifier = name.substring(0, i);
            name = name.substring(i + 1);
            String alias = qualifier;
            i = qualifier.indexOf(92);
            if (i != -1) {
                alias = qualifier.substring(0, i);
            }
            int length = name.length();
            int start = this.getCompanion().getOffset() - length;
            if (start + length < (prefixEnd = context.getReplacementEnd())) {
                length = prefixEnd - start;
            }
            Map aliases = PHPModelUtils.getAliasToNSMap((String)alias, (ModuleDeclaration)moduleDeclaration, (int)this.getCompanion().getOffset(), (IType)namespace, (boolean)false);
            for (Map.Entry entry : aliases.entrySet()) {
                if (!alias.equalsIgnoreCase((String)entry.getKey())) continue;
                qualifier = ((UsePart)entry.getValue()).getNamespace().getFullyQualifiedName();
                break;
            }
        } else {
            Map map = PHPModelUtils.getAliasToNSMap((String)"", (ModuleDeclaration)moduleDeclaration, (int)this.getCompanion().getOffset(), (IType)namespace, (boolean)false);
            for (Map.Entry entry : map.entrySet()) {
                if (!StringUtils.startsWithIgnoreCase((CharSequence)((CharSequence)entry.getKey()), (CharSequence)name)) continue;
                name = ((UsePart)entry.getValue()).getNamespace().getName();
                qualifier = ((UsePart)entry.getValue()).getNamespace().getNamespace().getName();
            }
        }
        IType[] iTypeArray = findTypes = PHPModelAccess.getDefault().findTypes(qualifier, name, ISearchEngine.MatchRule.EXACT, this.trueFlag, this.falseFlag, scope, null);
        int n = findTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            try {
                IField[] iFieldArray = PHPModelUtils.getTypeHierarchyField((IType)type, (ITypeHierarchy)this.getCompanion().getSuperTypeHierarchy(type, null), (String)("$" + context.getKeyPrefix()), (boolean)false, (IProgressMonitor)new NullProgressMonitor());
                int n3 = iFieldArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IField f = iFieldArray[n4];
                    if (PHPFlags.isPublic((int)f.getFlags()) && !PHPFlags.isStatic((int)f.getFlags()) && !"$value".equals(f.getElementName())) {
                        String suffix = "=";
                        if ("string".equalsIgnoreCase(f.getType())) {
                            suffix = "=\"\"";
                        }
                        reporter.reportField(f, suffix, replaceRange, true, 10000001, (Object)512);
                    } else {
                        IMethod[] setter = PHPModelUtils.getTypeHierarchyMethod((IType)type, (ITypeHierarchy)this.getCompanion().getSuperTypeHierarchy(type, null), (String)("set" + f.getElementName().substring(1)), (boolean)true, (IProgressMonitor)new NullProgressMonitor());
                        if (setter != null && setter.length > 0 && PHPFlags.isPublic((int)setter[0].getFlags()) && !PHPFlags.isStatic((int)setter[0].getFlags())) {
                            reporter.reportField(f, "=", replaceRange, true, 10000001, (Object)512);
                        }
                    }
                    ++n4;
                }
            }
            catch (ModelException e) {
                Logger.logException((Throwable)e);
            }
            catch (CoreException e) {
                Logger.logException((Throwable)e);
            }
            ++n2;
        }
    }
}

