/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.doctrine.core.goals.evaluator;

import com.dubture.doctrine.core.goals.RepositoryTypeGoal;
import com.dubture.doctrine.core.log.Logger;
import com.dubture.doctrine.core.model.DoctrineModelAccess;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.goals.GoalEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.typeinference.IModelAccessCache;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.context.IModelCacheContext;

public class RepositoryGoalEvaluator
extends GoalEvaluator {
    private RepositoryTypeGoal goal;
    private IEvaluatedType result;

    public RepositoryGoalEvaluator(RepositoryTypeGoal goal) {
        super((IGoal)goal);
        this.goal = goal;
    }

    public IGoal[] init() {
        IType type;
        if (!(this.goal.getContext() instanceof ISourceModuleContext)) {
            return IGoal.NO_GOALS;
        }
        ISourceModuleContext context = (ISourceModuleContext)this.goal.getContext();
        ISourceModule sourceModule = context.getSourceModule();
        IModelAccessCache cache = null;
        if (context instanceof IModelCacheContext) {
            cache = ((IModelCacheContext)context).getCache();
        }
        DoctrineModelAccess model = DoctrineModelAccess.getDefault();
        IScriptProject project = sourceModule.getScriptProject();
        String repo = null;
        if (!this.goal.getEtityName().contains(":")) {
            try {
                IType[] types = PHPModelUtils.getTypes((String)this.goal.getEtityName(), (ISourceModule)sourceModule, (int)0, (IModelAccessCache)cache, null);
                if (types != null && types.length > 0 && (repo = model.getRepositoryClass(PHPModelUtils.extractElementName((String)this.goal.getEtityName()), PHPModelUtils.extractNameSpaceName((String)this.goal.getEtityName()), project)) != null) {
                    this.result = new PHPClassType(repo);
                    return IGoal.NO_GOALS;
                }
            }
            catch (ModelException types) {
                // empty catch block
            }
        }
        if ((type = model.getExtensionType(this.goal.getEtityName(), project)) == null) {
            return IGoal.NO_GOALS;
        }
        String fullName = PHPModelUtils.getFullName((IType)type);
        repo = model.getRepositoryClass(PHPModelUtils.extractElementName((String)fullName), PHPModelUtils.extractNameSpaceName((String)fullName), project);
        if (repo == null) {
            this.result = new PHPClassType("Doctrine\\ORM", "EntityRepository");
            return IGoal.NO_GOALS;
        }
        try {
            IType[] types = PHPModelUtils.getTypes((String)repo, (ISourceModule)context.getSourceModule(), (int)0, (IModelAccessCache)cache, null);
            if (types.length > 0) {
                this.result = new PHPClassType(types[0].getFullyQualifiedName("\\"));
                return IGoal.NO_GOALS;
            }
        }
        catch (ModelException e1) {
            Logger.logException(e1);
        }
        IType extensionType = model.getExtensionType(repo, project);
        if (extensionType != null) {
            this.result = new PHPClassType(extensionType.getFullyQualifiedName("\\"));
        }
        return IGoal.NO_GOALS;
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        return IGoal.NO_GOALS;
    }

    public Object produceResult() {
        return this.result;
    }
}

