/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.doctrine.core.index;

import com.dubture.doctrine.annotation.model.Annotation;
import com.dubture.doctrine.annotation.model.AnnotationBlock;
import com.dubture.doctrine.annotation.model.AnnotationClass;
import com.dubture.doctrine.annotation.model.AnnotationVisitor;
import com.dubture.doctrine.annotation.model.ArgumentValueType;
import com.dubture.doctrine.annotation.model.IArgumentValue;
import com.dubture.doctrine.core.AnnotationParserUtil;
import com.dubture.doctrine.core.DoctrineNature;
import com.dubture.doctrine.core.compiler.IAnnotationModuleDeclaration;
import com.dubture.doctrine.core.index.DoctrineBuilder;
import com.dubture.doctrine.core.log.Logger;
import com.dubture.doctrine.core.model.Entity;
import com.dubture.doctrine.internal.core.compiler.DoctrineSourceElementRequestor;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.index2.IIndexingRequestor;
import org.eclipse.dltk.internal.core.ExternalSourceModule;
import org.eclipse.php.core.compiler.ast.nodes.ClassDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.IPHPDocAwareDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.core.compiler.ast.nodes.UseStatement;
import org.eclipse.php.core.compiler.ast.visitor.PHPASTVisitor;
import org.eclipse.php.core.index.PHPIndexingVisitorExtension;

public class DoctrineIndexingVisitorExtension
extends PHPIndexingVisitorExtension {
    private NamespaceDeclaration namespace;
    private IAnnotationModuleDeclaration decl;
    private HashMap<String, String> parts;
    private boolean enabled;
    private boolean declarationInitialized = false;

    private IAnnotationModuleDeclaration getAnnotationDeclaration() {
        if (!this.declarationInitialized) {
            this.declarationInitialized = true;
            try {
                this.decl = AnnotationParserUtil.getModule(this.sourceModule);
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
        return this.decl;
    }

    public void setSourceModule(ISourceModule module) {
        super.setSourceModule(module);
        IScriptProject scriptProject = module.getScriptProject();
        try {
            if (!(module instanceof ExternalSourceModule) && scriptProject.exists() && scriptProject.getProject().hasNature(DoctrineNature.NATURE_ID)) {
                this.enabled = true;
            } else {
                this.enabled = false;
                this.declarationInitialized = true;
            }
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        if (!this.enabled) {
            return;
        }
        this.parts = new HashMap();
        this.indexPendingEntities();
    }

    protected void indexPendingEntities() {
        List<Entity> pending = DoctrineBuilder.getPendingEntities();
        for (Entity entity : pending) {
            IIndexingRequestor.ReferenceInfo entityInfo = new IIndexingRequestor.ReferenceInfo(901, 0, 0, entity.getElementName(), null, entity.getFullyQualifiedName());
            this.requestor.addReference(entityInfo);
        }
    }

    public boolean visit(TypeDeclaration typeDeclaration) throws Exception {
        if (!this.enabled) {
            return false;
        }
        if (typeDeclaration instanceof NamespaceDeclaration) {
            NamespaceDeclaration namespaceDeclaration;
            this.namespace = namespaceDeclaration = (NamespaceDeclaration)typeDeclaration;
            this.parts = new HashMap();
            namespaceDeclaration.traverse((ASTVisitor)new PHPASTVisitor(){

                public boolean visit(UseStatement s) throws Exception {
                    if (s.getStatementType() != 0) {
                        return false;
                    }
                    for (UsePart part : s.getParts()) {
                        if (part.getNamespace() == null) continue;
                        String fullName = part.getNamespace().getFullyQualifiedName();
                        DoctrineIndexingVisitorExtension.this.parts.put(part.getAlias() == null ? part.getNamespace().getName().toLowerCase() : part.getAlias().getName().toLowerCase(), fullName);
                    }
                    return false;
                }

                public boolean visitGeneral(ASTNode node) throws Exception {
                    if (node instanceof Declaration) {
                        return false;
                    }
                    return super.visitGeneral(node);
                }
            });
        }
        return true;
    }

    protected void processClassDeclaration(ClassDeclaration classDeclaration, IIndexingRequestor.DeclarationInfo info) {
        List annotations = this.decl.readAnnotations((ASTNode)classDeclaration).getAnnotations();
        if (annotations.size() < 1) {
            return;
        }
        Annotation annotation = null;
        for (Annotation a : annotations) {
            if (!a.getClassName().equals("Entity")) continue;
            annotation = a;
            break;
        }
        if (annotation == null) {
            info.flags = DoctrineSourceElementRequestor.prepareAnnotationFlags(info.flags, annotations);
            return;
        }
        String qualifier = null;
        if (this.namespace != null) {
            qualifier = this.namespace.getName();
        }
        IIndexingRequestor.ReferenceInfo entityInfo = new IIndexingRequestor.ReferenceInfo(901, classDeclaration.sourceStart(), classDeclaration.sourceEnd(), classDeclaration.getName(), null, qualifier);
        this.requestor.addReference(entityInfo);
        IArgumentValue repoArgumentValue = annotation.getArgumentValue("repositoryClass");
        if (repoArgumentValue == null || repoArgumentValue.getType() != ArgumentValueType.STRING) {
            return;
        }
        String repositoryClass = (String)repoArgumentValue.getValue();
        IIndexingRequestor.ReferenceInfo repositoryInfo = new IIndexingRequestor.ReferenceInfo(900, classDeclaration.sourceStart(), classDeclaration.sourceEnd(), classDeclaration.getName(), repositoryClass, qualifier);
        this.requestor.addReference(repositoryInfo);
    }

    public void modifyDeclaration(ASTNode node, IIndexingRequestor.DeclarationInfo info) {
        if (!this.enabled) {
            return;
        }
        if (node == null || node instanceof InterfaceDeclaration || node instanceof NamespaceDeclaration || !(node instanceof IPHPDocAwareDeclaration)) {
            return;
        }
        PHPDocBlock block = ((IPHPDocAwareDeclaration)node).getPHPDoc();
        if (block == null || block.getTags(PHPDocTag.TagKind.UNKNOWN).length == 0 || this.getAnnotationDeclaration() == null) {
            return;
        }
        if (node instanceof ClassDeclaration) {
            this.processClassDeclaration((ClassDeclaration)node, info);
        }
        this.indexReferences(node);
    }

    private void indexReferences(ASTNode node) {
        AnnotationBlock annotations = this.decl.readAnnotations(node);
        if (annotations != null) {
            annotations.traverse((AnnotationVisitor)new ReferenceAnnotationVisitor());
        }
    }

    private class ReferenceAnnotationVisitor
    extends AnnotationVisitor {
        private ReferenceAnnotationVisitor() {
        }

        public boolean visit(AnnotationClass node) {
            String fullName;
            if (!node.hasNamespace()) {
                if (DoctrineIndexingVisitorExtension.this.parts.containsKey(node.getClassName().toLowerCase())) {
                    fullName = DoctrineIndexingVisitorExtension.this.parts.get(node.getClassName().toLowerCase());
                } else {
                    if ("Annotation".equals(node.getClassName())) {
                        return super.visit(node);
                    }
                    fullName = "Doctrine\\Common\\Annotations\\Annotation\\" + node.getClassName();
                }
            } else {
                fullName = DoctrineIndexingVisitorExtension.this.parts.containsKey(node.getFirstNamespacePart().toLowerCase()) ? String.valueOf(DoctrineIndexingVisitorExtension.this.parts.get(node.getFirstNamespacePart().toLowerCase())) + '\\' + node.getClassName() : node.getFullyQualifiedName();
            }
            int i = fullName.lastIndexOf(92);
            String qualifier = null;
            String name = fullName;
            if (i != -1) {
                qualifier = name.substring(0, i);
                name = name.substring(i + 1);
            }
            DoctrineIndexingVisitorExtension.this.requestor.addReference(new IIndexingRequestor.ReferenceInfo(7, node.getSourcePosition().startOffset + 1, node.getSourcePosition().length - 1, name, null, qualifier));
            return super.visit(node);
        }
    }
}

