/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.doctrine.core.index;

import com.dubture.doctrine.core.index.DoctrineBuilder;
import com.dubture.doctrine.core.model.Entity;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlMappingParser {
    private XPath xPath = XPathFactory.newInstance().newXPath();
    private Document doc;

    public XmlMappingParser(InputStream file) throws Exception {
        this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
    }

    public void parse() throws Exception {
        String servicePath = "/doctrine-mapping/entity";
        NodeList routeNodes = this.getNodes(servicePath);
        int i = 0;
        while (i < routeNodes.getLength()) {
            Node node = routeNodes.item(i);
            NamedNodeMap atts = node.getAttributes();
            String phpClass = null;
            int j = 0;
            while (j < atts.getLength()) {
                Attr attr = (Attr)atts.item(j);
                String key = attr.getName();
                if (!key.equals("repository-class") && key.equals("name")) {
                    phpClass = attr.getValue();
                }
                ++j;
            }
            if (phpClass != null) {
                Entity entity = new Entity(null, phpClass);
                DoctrineBuilder.addPendingEntity(entity);
            }
            ++i;
        }
    }

    private NodeList getNodes(String path) throws Exception {
        XPathExpression xpathExpr = this.xPath.compile(path);
        Object result = xpathExpr.evaluate(this.doc, XPathConstants.NODESET);
        return (NodeList)result;
    }
}

