/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.doctrine.core.model;

import com.dubture.doctrine.core.goals.IEntityResolver;
import com.dubture.doctrine.core.index.ICleanListener;
import com.dubture.doctrine.core.log.Logger;
import com.dubture.doctrine.core.model.Entity;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.index2.search.ISearchRequestor;
import org.eclipse.dltk.core.index2.search.ModelAccess;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.core.util.LRUCache;
import org.eclipse.php.internal.core.PHPLanguageToolkit;
import org.eclipse.php.internal.core.model.PHPModelAccess;

public class DoctrineModelAccess
extends PHPModelAccess
implements ICleanListener {
    private static final String ENTITYRESOLVER_ID = "com.dubture.doctrine.core.entityResolvers";
    private static DoctrineModelAccess modelInstance = null;
    private List<IEntityResolver> resolvers = null;
    private LRUCache entityCache = new LRUCache(10);
    private final String NULL_RESULT = "__NOT_FOUND__";

    public static DoctrineModelAccess getDefault() {
        if (modelInstance == null) {
            modelInstance = new DoctrineModelAccess();
        }
        return modelInstance;
    }

    public String getRepositoryClass(String className, String qualifier, IScriptProject project) {
        if (className == null) {
            return null;
        }
        String key = String.valueOf(project.getElementName()) + "/" + className;
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)project);
        if (scope == null) {
            return null;
        }
        ISearchEngine engine = ModelAccess.getSearchEngine((IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
        final ArrayList repos = new ArrayList();
        engine.search(900, qualifier, className, 0, 0, 100, ISearchEngine.SearchFor.REFERENCES, ISearchEngine.MatchRule.EXACT, scope, new ISearchRequestor(){

            public void match(int elementType, int flags, int offset, int length, int nameOffset, int nameLength, String elementName, String metadata, String doc, String qualifier, String parent, ISourceModule sourceModule, boolean isReference) {
                if (metadata != null) {
                    repos.add(metadata);
                }
            }
        }, null);
        if (repos.size() == 1) {
            String repo = (String)repos.get(0);
            return repo;
        }
        return null;
    }

    public List<Entity> getEntities(IScriptProject project) {
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)project);
        if (scope == null) {
            return null;
        }
        ISearchEngine engine = ModelAccess.getSearchEngine((IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
        final ArrayList<Entity> entities = new ArrayList<Entity>();
        engine.search(901, null, null, 0, 0, 100, ISearchEngine.SearchFor.REFERENCES, ISearchEngine.MatchRule.PREFIX, scope, new ISearchRequestor(){

            public void match(int elementType, int flags, int offset, int length, int nameOffset, int nameLength, String elementName, String metadata, String doc, String qualifier, String parent, ISourceModule sourceModule, boolean isReference) {
                String name = "";
                if (qualifier != null) {
                    name = String.valueOf(qualifier) + "\\";
                }
                name = String.valueOf(name) + elementName;
                Entity e = new Entity(null, name);
                entities.add(e);
            }
        }, null);
        return entities;
    }

    public IType getExtensionType(String classname, IScriptProject project) {
        String key = String.valueOf(classname) + project.getElementName();
        Object object = this.entityCache.get((Object)key);
        if (object != null && object.equals("__NOT_FOUND__")) {
            return null;
        }
        if (object instanceof IType) {
            return (IType)object;
        }
        for (IEntityResolver resolver : this.getResolvers()) {
            IType type = resolver.resolve(classname, project);
            if (type == null) continue;
            this.entityCache.put((Object)key, (Object)type);
            return type;
        }
        this.entityCache.put((Object)classname, (Object)"__NOT_FOUND__");
        return null;
    }

    private List<IEntityResolver> getResolvers() {
        if (this.resolvers != null) {
            return this.resolvers;
        }
        this.resolvers = new ArrayList<IEntityResolver>();
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(ENTITYRESOLVER_ID);
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                Object extension = element.createExecutableExtension("class");
                if (extension instanceof IEntityResolver) {
                    this.resolvers.add((IEntityResolver)extension);
                }
                ++n2;
            }
        }
        catch (Exception e1) {
            Logger.logException(e1);
        }
        return this.resolvers;
    }

    @Override
    public void clean() {
        this.entityCache.flush();
    }
}

