/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.doctrine.core.utils;

import com.dubture.doctrine.annotation.model.AnnotationBlock;
import com.dubture.doctrine.annotation.parser.AnnotationCommentParser;
import com.dubture.doctrine.core.log.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.core.ast.nodes.Comment;
import org.eclipse.php.core.compiler.ast.nodes.ClassDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.IPHPDocAwareDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.core.compiler.ast.nodes.PHPMethodDeclaration;

public class AnnotationUtils {
    protected static final String[] PHPDOC_TAGS_EXTRA = new String[]{"api", "inheritdoc"};
    protected static final AnnotationBlock EMPTY_ANNOTATIONS = new AnnotationBlock(Collections.unmodifiableList(new ArrayList(0)));

    public static AnnotationBlock extractAnnotations(AnnotationCommentParser parser, IPHPDocAwareDeclaration declaration, ISourceModule sourceModule) {
        try {
            return AnnotationUtils.extractAnnotations(parser, declaration, sourceModule.getSource());
        }
        catch (ModelException e) {
            Logger.logException("Unable to extract annotations from declaration " + AnnotationUtils.getDeclarationName(declaration), e);
            return EMPTY_ANNOTATIONS;
        }
    }

    public static AnnotationBlock extractAnnotations(AnnotationCommentParser parser, IPHPDocAwareDeclaration declaration, String source) {
        try {
            PHPDocBlock comment = declaration.getPHPDoc();
            if (comment == null || comment.getCommentType() != 2) {
                return EMPTY_ANNOTATIONS;
            }
            int commentStartOffset = comment.sourceStart();
            String commentSource = source.substring(commentStartOffset, comment.sourceEnd());
            return parser.parse(commentSource, commentStartOffset);
        }
        catch (Exception exception) {
            Logger.logException("Unable to extract annotations from declaration " + AnnotationUtils.getDeclarationName(declaration), exception);
            return EMPTY_ANNOTATIONS;
        }
    }

    public static AnnotationBlock extractAnnotations(AnnotationCommentParser parser, Comment comment, ISourceModule sourceModule) {
        if (comment == null || comment.getCommentType() != 2) {
            return EMPTY_ANNOTATIONS;
        }
        try {
            int commentStartOffset = comment.getStart();
            int commentEndOffset = comment.getEnd();
            String commentSource = AnnotationUtils.getCommentSource(sourceModule, commentStartOffset, commentEndOffset);
            return parser.parse(commentSource, commentStartOffset);
        }
        catch (Exception exception) {
            Logger.logException("Unable to extract annotations from comment", exception);
            return EMPTY_ANNOTATIONS;
        }
    }

    public static AnnotationCommentParser createParser(String[] includedClassNames) {
        AnnotationCommentParser parser = new AnnotationCommentParser();
        LinkedList<String> phpDocTags = new LinkedList<String>();
        PHPDocTag.TagKind[] tagKindArray = PHPDocTag.TagKind.values();
        int n = tagKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            PHPDocTag.TagKind tag = tagKindArray[n2];
            phpDocTags.add(tag.getName());
            ++n2;
        }
        parser.addExcludedClassNames(phpDocTags.toArray(new String[0]));
        parser.addExcludedClassNames(PHPDOC_TAGS_EXTRA);
        if (includedClassNames != null) {
            parser.addIncludedClassNames(includedClassNames);
        }
        return parser;
    }

    private static String getDeclarationName(IPHPDocAwareDeclaration declaration) {
        if (declaration instanceof PHPMethodDeclaration) {
            return "method: " + ((PHPMethodDeclaration)declaration).getName();
        }
        if (declaration instanceof ClassDeclaration) {
            return "class: " + ((ClassDeclaration)declaration).getName();
        }
        return "unknown";
    }

    public static AnnotationCommentParser createParser() {
        return AnnotationUtils.createParser(PHPDOC_TAGS_EXTRA);
    }

    private static String getCommentSource(ISourceModule sourceModule, int start, int end) throws ModelException {
        String source = sourceModule.getSource();
        return source.substring(start, end);
    }
}

