/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.doctrine.internal.core.build;

import com.dubture.doctrine.core.AnnotationParserUtil;
import com.dubture.doctrine.core.DoctrineNature;
import com.dubture.doctrine.core.compiler.IAnnotationModuleDeclaration;
import com.dubture.doctrine.internal.core.compiler.AnnotationParser;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.parser.IModuleDeclaration;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.compiler.problem.ProblemCollector;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModuleInfoCache;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.builder.AbstractBuildParticipantType;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.IBuildParticipant;
import org.eclipse.dltk.core.builder.IBuildParticipantFactory;
import org.eclipse.php.core.compiler.ast.nodes.PHPModuleDeclaration;

public class AnnotationBuildParticipantFactory
extends AbstractBuildParticipantType
implements IBuildParticipantFactory {
    public IBuildParticipant createBuildParticipant(IScriptProject project) throws CoreException {
        if (!project.getProject().isAccessible()) {
            return null;
        }
        if (project.getProject().hasNature(DoctrineNature.NATURE_ID)) {
            return new AnnotationBuildParticipant();
        }
        return null;
    }

    private class AnnotationBuildParticipant
    implements IBuildParticipant {
        private AnnotationBuildParticipant() {
        }

        public void build(IBuildContext context) throws CoreException {
            IAnnotationModuleDeclaration annotationModule;
            if (context.get(IBuildContext.ATTR_MODULE_DECLARATION) == null) {
                return;
            }
            ISourceModuleInfoCache.ISourceModuleInfo cacheEntry = SourceParserUtil.getCache().get(context.getSourceModule());
            if (context.getBuildType() != 1 && (annotationModule = AnnotationParserUtil.getModuleFromCache(cacheEntry, context.getProblemReporter())) != null) {
                context.set(IAnnotationModuleDeclaration.class.getName(), (Object)annotationModule);
                return;
            }
            PHPModuleDeclaration module = (PHPModuleDeclaration)context.get(IBuildContext.ATTR_MODULE_DECLARATION);
            ProblemCollector problemCollector = new ProblemCollector();
            AnnotationParser parser = new AnnotationParser();
            annotationModule = parser.parse(context.getSourceModule(), (IModuleDeclaration)module, (IProblemReporter)problemCollector);
            AnnotationParserUtil.putModuleToCache(cacheEntry, annotationModule, problemCollector);
            problemCollector.copyTo(context.getProblemReporter());
            context.set(IAnnotationModuleDeclaration.class.getName(), (Object)annotationModule);
        }
    }
}

