/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.doctrine.internal.core.compiler;

import com.dubture.doctrine.annotation.model.AnnotationBlock;
import com.dubture.doctrine.core.compiler.IAnnotationModuleDeclaration;
import com.dubture.doctrine.core.log.Logger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.core.compiler.ast.nodes.IPHPDocAwareDeclaration;

public class AnnotationModuleDeclaration
implements IAnnotationModuleDeclaration {
    private static AnnotationBlock EMPTY = new AnnotationBlock(new ArrayList(0));
    private Map<Integer, AnnotationBlock> annotations = new LinkedHashMap<Integer, AnnotationBlock>();

    public void addBlock(int start, AnnotationBlock block) {
        this.annotations.put(start, block);
    }

    public AnnotationBlock read(int position) {
        if (this.annotations.containsKey(position)) {
            return this.annotations.get(position);
        }
        return EMPTY;
    }

    @Override
    public AnnotationBlock readAnnotations(IPHPDocAwareDeclaration astNode) {
        return this.read(((ASTNode)astNode).sourceStart());
    }

    @Override
    public AnnotationBlock readAnnotations(ASTNode node) {
        return this.read(node.start());
    }

    @Override
    public AnnotationBlock readAnnotations(ISourceReference ref) {
        try {
            if (ref instanceof IField) {
                return this.read(ref.getNameRange().getOffset());
            }
            return this.read(ref.getSourceRange().getOffset());
        }
        catch (ModelException e) {
            Logger.logException(e);
            return EMPTY;
        }
    }

    @Override
    public AnnotationBlock[] getBlocks() {
        return this.annotations.values().toArray(new AnnotationBlock[this.annotations.size()]);
    }

    @Override
    public AnnotationBlock readAnnotations(int offset, int length) {
        return this.read(offset);
    }
}

