/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.doctrine.internal.core.compiler;

import com.dubture.doctrine.annotation.parser.AnnotationCommentParser;
import com.dubture.doctrine.core.DoctrineCorePlugin;
import com.dubture.doctrine.core.compiler.IAnnotationModuleDeclaration;
import com.dubture.doctrine.core.utils.AnnotationUtils;
import com.dubture.doctrine.internal.core.compiler.AnnotationModuleDeclaration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.parser.IModuleDeclaration;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.core.ExternalSourceModule;
import org.eclipse.php.core.compiler.ast.nodes.ClassDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.IPHPDocAwareDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PHPFieldDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PHPMethodDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.TraitDeclaration;
import org.eclipse.php.core.compiler.ast.visitor.PHPASTVisitor;

public class AnnotationParser {
    public IAnnotationModuleDeclaration parse(ISourceModule sourceModule, IModuleDeclaration moduleDeclaration, IProblemReporter reporter) throws CoreException {
        if (sourceModule instanceof ExternalSourceModule) {
            return null;
        }
        AnnotationModuleDeclaration decl = new AnnotationModuleDeclaration();
        ASTVisitor astVisitor = new ASTVisitor(sourceModule, decl);
        if (moduleDeclaration instanceof ModuleDeclaration) {
            try {
                ((ModuleDeclaration)moduleDeclaration).traverse((org.eclipse.dltk.ast.ASTVisitor)astVisitor);
            }
            catch (CoreException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, DoctrineCorePlugin.ID, "Problem during parse", (Throwable)e));
            }
        }
        return decl;
    }

    private class ASTVisitor
    extends PHPASTVisitor {
        private ISourceModule sourceModule;
        private AnnotationModuleDeclaration ad;
        private AnnotationCommentParser parser;
        private boolean inType = false;
        private String content;

        public ASTVisitor(ISourceModule sourceModule, AnnotationModuleDeclaration ad) {
            this.sourceModule = sourceModule;
            this.ad = ad;
            this.parser = AnnotationUtils.createParser();
        }

        public boolean visit(PHPMethodDeclaration s) throws Exception {
            if (!this.inType) {
                return false;
            }
            this.parse((IPHPDocAwareDeclaration)s);
            return false;
        }

        public boolean visit(PHPFieldDeclaration s) throws Exception {
            if (!this.inType) {
                return false;
            }
            this.parse((IPHPDocAwareDeclaration)s);
            return false;
        }

        public boolean visit(TraitDeclaration s) throws Exception {
            this.inType = true;
            this.parse((IPHPDocAwareDeclaration)s);
            return super.visit(s);
        }

        public boolean visit(InterfaceDeclaration s) throws Exception {
            return false;
        }

        public boolean visit(ClassDeclaration s) throws Exception {
            this.inType = true;
            this.parse((IPHPDocAwareDeclaration)s);
            return true;
        }

        public boolean endvisit(ClassDeclaration s) throws Exception {
            this.inType = false;
            return false;
        }

        public boolean endvisit(TraitDeclaration s) throws Exception {
            this.inType = false;
            return false;
        }

        private void parse(IPHPDocAwareDeclaration node) throws Exception {
            if (this.content == null) {
                this.content = this.sourceModule.getBuffer() != null ? new String(this.sourceModule.getBuffer().getCharacters()) : this.sourceModule.getSource();
            }
            this.ad.addBlock(((ASTNode)node).sourceStart(), AnnotationUtils.extractAnnotations(this.parser, node, this.content));
        }
    }
}

