/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.doctrine.internal.core.compiler;

import com.dubture.doctrine.annotation.model.Annotation;
import com.dubture.doctrine.annotation.model.ArgumentValueType;
import com.dubture.doctrine.annotation.model.ArrayValue;
import com.dubture.doctrine.annotation.model.IArgumentValue;
import com.dubture.doctrine.core.AnnotationParserUtil;
import com.dubture.doctrine.core.DoctrineNature;
import com.dubture.doctrine.core.compiler.DoctrineFlags;
import com.dubture.doctrine.core.compiler.IAnnotationModuleDeclaration;
import com.dubture.doctrine.core.log.Logger;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.core.ExternalSourceModule;
import org.eclipse.php.core.compiler.PHPSourceElementRequestorExtension;
import org.eclipse.php.core.compiler.ast.nodes.IPHPDocAwareDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocTag;

public class DoctrineSourceElementRequestor
extends PHPSourceElementRequestorExtension {
    private static final String ANNOTATION_TAG = "Annotation";
    private static final String TARGET_TAG = "Target";
    private static final String TARGET_METHOD = "METHOD";
    private static final String TARGET_FIELD = "PROPERTY";
    private static final String TARGET_CLASS = "CLASS";
    private static final String TARGET_ANNOTATION = "ANNOTATION";
    private static final String TARGET_ALL = "ALL";
    private boolean enabled = false;
    private IAnnotationModuleDeclaration decl;
    private boolean declarationInitialized = false;

    private IAnnotationModuleDeclaration getAnnotationDeclaration() {
        if (!this.declarationInitialized) {
            this.declarationInitialized = true;
            try {
                this.decl = AnnotationParserUtil.getModule((ISourceModule)this.getSourceModule().getModelElement());
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
        return this.decl;
    }

    public void setSourceModule(IModuleSource sourceModule) {
        super.setSourceModule(sourceModule);
        IScriptProject scriptProject = this.getSourceModule().getModelElement().getScriptProject();
        try {
            if (!(sourceModule instanceof ExternalSourceModule) && scriptProject.exists() && scriptProject.getProject().hasNature(DoctrineNature.NATURE_ID)) {
                this.enabled = true;
            } else {
                this.enabled = false;
                this.declarationInitialized = true;
            }
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
    }

    public boolean visit(TypeDeclaration s) throws Exception {
        return super.visit(s);
    }

    public void modifyClassInfo(TypeDeclaration typeDeclaration, IElementRequestor.TypeInfo ti) {
        if (!this.enabled || !DoctrineFlags.isClass((int)ti.modifiers)) {
            return;
        }
        this.checkAnnotation(typeDeclaration, ti);
    }

    private void checkAnnotation(TypeDeclaration typeDeclaration, IElementRequestor.TypeInfo ti) {
        if (typeDeclaration instanceof IPHPDocAwareDeclaration && ((IPHPDocAwareDeclaration)typeDeclaration).getPHPDoc() != null && ((IPHPDocAwareDeclaration)typeDeclaration).getPHPDoc().getTags(PHPDocTag.TagKind.UNKNOWN).length > 0) {
            List annotations = this.getAnnotationDeclaration().readAnnotations((ASTNode)typeDeclaration).getAnnotations();
            ti.modifiers = DoctrineSourceElementRequestor.prepareAnnotationFlags(ti.modifiers, annotations);
            typeDeclaration.setModifiers(ti.modifiers);
        }
    }

    public static int prepareAnnotationFlags(int flags, List<Annotation> annotations) {
        Annotation target = null;
        boolean isAnnotation = false;
        for (Annotation el : annotations) {
            if (el.getFirstNamespacePart() == null && el.getAnnotationClass().getClassName().equals(ANNOTATION_TAG)) {
                flags |= 0x1000;
                isAnnotation = true;
                continue;
            }
            if (el.getFirstNamespacePart() != null || !el.getAnnotationClass().getClassName().equals(TARGET_TAG)) continue;
            target = el;
        }
        if (!isAnnotation) {
            return flags;
        }
        if (target == null) {
            flags |= 0x16004000;
        } else if (target.hasArgument(0) && target.getArgumentValue(0).getType() == ArgumentValueType.ARRAY) {
            ArrayValue val = (ArrayValue)target.getArgumentValue(0);
            for (IArgumentValue pos : (List)val.getValue()) {
                if (TARGET_ALL.equals(pos.getValue())) {
                    flags |= 0x16004000;
                    continue;
                }
                if (TARGET_ANNOTATION.equals(pos.getValue())) {
                    flags |= 0x2000000;
                    continue;
                }
                if (TARGET_FIELD.equals(pos.getValue())) {
                    flags |= 0x4000000;
                    continue;
                }
                if (TARGET_METHOD.equals(pos.getValue())) {
                    flags |= 0x10000000;
                    continue;
                }
                if (!TARGET_CLASS.equals(pos.getValue())) continue;
                flags |= 0x4000;
            }
        } else if (target.hasArgument(0) && target.getArgumentValue(0).getType() == ArgumentValueType.STRING) {
            Object value = target.getArgumentValue(0).getValue();
            if (TARGET_ALL.equals(value)) {
                flags |= 0x16004000;
            } else if (TARGET_ANNOTATION.equals(value)) {
                flags |= 0x2000000;
            } else if (TARGET_FIELD.equals(value)) {
                flags |= 0x4000000;
            } else if (TARGET_METHOD.equals(value)) {
                flags |= 0x10000000;
            } else if (TARGET_CLASS.equals(value)) {
                flags |= 0x4000;
            }
        } else {
            flags |= 0x16004000;
        }
        return flags;
    }
}

