/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.doctrine.internal.core.refactoring;

import com.dubture.doctrine.annotation.model.AnnotationBlock;
import com.dubture.doctrine.annotation.model.AnnotationClass;
import com.dubture.doctrine.annotation.model.AnnotationVisitor;
import com.dubture.doctrine.core.AnnotationParserUtil;
import com.dubture.doctrine.core.DoctrineCorePlugin;
import com.dubture.doctrine.core.compiler.DoctrineFlags;
import com.dubture.doctrine.core.compiler.IAnnotationModuleDeclaration;
import com.dubture.doctrine.core.log.Logger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.index2.search.ISearchRequestor;
import org.eclipse.dltk.core.index2.search.ModelAccess;
import org.eclipse.dltk.core.manipulation.SourceModuleChange;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.php.core.compiler.ast.nodes.ClassDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PHPFieldDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PHPMethodDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.TraitDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.core.compiler.ast.nodes.UseStatement;
import org.eclipse.php.core.compiler.ast.visitor.PHPASTVisitor;
import org.eclipse.php.internal.core.PHPLanguageToolkit;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class RenameAnnotationParticipant
extends RenameParticipant {
    private IType fType;
    private String fFullName;

    protected boolean initialize(Object element) {
        this.fType = (IType)element;
        this.fFullName = PHPModelUtils.getFullName((IType)this.fType);
        try {
            if (DoctrineFlags.isAnnotation(((IType)element).getFlags())) {
                return true;
            }
        }
        catch (ModelException e) {
            Logger.logException(e);
        }
        return false;
    }

    public String getName() {
        return "Rename doctrine annotation";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        final HashSet list = new HashSet();
        IScriptProject project = this.fType.getScriptProject();
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)project, (int)3);
        ISearchEngine engine = ModelAccess.getSearchEngine((IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
        int i = this.fFullName.lastIndexOf(92);
        String qualifier = null;
        String name = this.fFullName;
        if (i != -1) {
            qualifier = name.substring(0, i);
            name = name.substring(i + 1);
        }
        pm.subTask("Search references");
        engine.search(7, qualifier, name, 0, 0, 0, ISearchEngine.SearchFor.REFERENCES, ISearchEngine.MatchRule.EXACT, scope, new ISearchRequestor(){

            public void match(int elementType, int flags, int offset, int length, int nameOffset, int nameLength, String elementName, String metadata, String doc, String qualifier, String parent, ISourceModule sourceModule, boolean isReference) {
                list.add(sourceModule);
            }
        }, null);
        pm.subTask("Prepare changes");
        CompositeChange changes = new CompositeChange("Rename annotation class");
        boolean found = false;
        for (ISourceModule module : list) {
            IAnnotationModuleDeclaration mod;
            ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)module);
            if (moduleDeclaration == null || (mod = AnnotationParserUtil.getModule(module)) == null) continue;
            AnnotationChecker checker = new AnnotationChecker(mod);
            try {
                moduleDeclaration.traverse((ASTVisitor)checker);
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, DoctrineCorePlugin.ID, "Error during traverse", (Throwable)e));
            }
            if (checker.replaces.isEmpty()) continue;
            try {
                TextChange change = this.getTextChange(module.getResource());
                if (change == null) {
                    change = new SourceModuleChange(module.getResource().getName(), module);
                    change.setEdit((TextEdit)new MultiTextEdit());
                    changes.add((Change)change);
                    found = true;
                }
                TextEditGroup textEditGroup = new TextEditGroup("Update annotation references");
                change.addTextEditGroup(textEditGroup);
                for (TextEdit edit : checker.replaces) {
                    textEditGroup.addTextEdit(edit);
                    change.addEdit(edit);
                }
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }
        return found ? changes : null;
    }

    private class AnnotationChecker
    extends PHPASTVisitor {
        private Map<String, String> parts;
        private Map<String, String> aliasedParts;
        private List<TextEdit> replaces = new LinkedList<TextEdit>();
        private IAnnotationModuleDeclaration annotationModule;

        public AnnotationChecker(IAnnotationModuleDeclaration annotationModule) {
            this.parts = new HashMap<String, String>();
            this.aliasedParts = new HashMap<String, String>();
            this.annotationModule = annotationModule;
        }

        public boolean visit(NamespaceDeclaration s) throws Exception {
            this.parts = new HashMap<String, String>();
            this.aliasedParts = new HashMap<String, String>();
            return super.visit(s);
        }

        public boolean visit(UseStatement s) {
            if (s.getStatementType() != 0) {
                return false;
            }
            for (UsePart part : s.getParts()) {
                if (part.getNamespace() == null) continue;
                String fullName = part.getNamespace().getFullyQualifiedName().toLowerCase();
                if (part.getAlias() == null) {
                    this.parts.put(part.getNamespace().getName().toLowerCase(), fullName);
                    continue;
                }
                this.aliasedParts.put(part.getAlias().getName().toLowerCase(), fullName);
            }
            return false;
        }

        public boolean visit(PHPMethodDeclaration s) throws Exception {
            this.check((ASTNode)s);
            return super.visit(s);
        }

        public boolean visit(PHPFieldDeclaration s) throws Exception {
            this.check((ASTNode)s);
            return super.visit(s);
        }

        public boolean visit(TraitDeclaration s) throws Exception {
            this.check((ASTNode)s);
            return super.visit(s);
        }

        public boolean visit(ClassDeclaration s) throws Exception {
            this.check((ASTNode)s);
            return super.visit(s);
        }

        private void check(ASTNode node) throws Exception {
            AnnotationBlock readAnnotations = this.annotationModule.readAnnotations(node);
            if (readAnnotations == null || readAnnotations.isEmpty()) {
                return;
            }
            readAnnotations.traverse(new AnnotationVisitor(){

                public boolean visit(AnnotationClass node) {
                    String realName;
                    if (!node.hasNamespace() && AnnotationChecker.this.aliasedParts.containsKey(node.getClassName().toLowerCase())) {
                        return true;
                    }
                    if (!((AnnotationChecker)AnnotationChecker.this).RenameAnnotationParticipant.this.fType.getElementName().equalsIgnoreCase(node.getClassName())) {
                        return true;
                    }
                    String useName = (node.hasNamespace() ? node.getFirstNamespacePart() : node.getClassName()).toLowerCase();
                    if (AnnotationChecker.this.aliasedParts.containsKey(useName)) {
                        realName = node.hasNamespace() ? String.valueOf(AnnotationChecker.this.aliasedParts.get(useName)) + '\\' + node.getClassName() : AnnotationChecker.this.aliasedParts.get(useName);
                    } else if (AnnotationChecker.this.parts.containsKey(useName)) {
                        realName = node.hasNamespace() ? String.valueOf(AnnotationChecker.this.parts.get(useName)) + '\\' + node.getClassName() : AnnotationChecker.this.parts.get(useName);
                    } else {
                        if ("Annotation".equals(node.getClassName())) {
                            return true;
                        }
                        realName = "Doctrine\\Common\\Annotations\\Annotation\\" + node.getClassName();
                    }
                    if (!((AnnotationChecker)AnnotationChecker.this).RenameAnnotationParticipant.this.fFullName.equalsIgnoreCase(realName)) {
                        return true;
                    }
                    int offset = node.getSourcePosition().startOffset + 1 + node.getNamespace().length();
                    AnnotationChecker.this.replaces.add((TextEdit)new ReplaceEdit(offset, node.getClassName().length(), RenameAnnotationParticipant.this.getArguments().getNewName()));
                    return super.visit(node);
                }
            });
        }
    }
}

