/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.doctrine.internal.core.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPHPScriptRegion;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class PHPDocTextSequenceUtilities {
    public static String getPHPRegionType(IStructuredDocument document, int offset) {
        if (document == null) {
            return null;
        }
        IStructuredDocumentRegion sRegion = document.getRegionAtCharacterOffset(offset);
        if (sRegion == null) {
            return null;
        }
        ITextRegion tRegion = sRegion.getRegionAtCharacterOffset(offset);
        IStructuredDocumentRegion container = sRegion;
        if (tRegion instanceof ITextRegionContainer) {
            container = (ITextRegionContainer)tRegion;
            tRegion = container.getRegionAtCharacterOffset(offset);
        }
        if (tRegion == null || tRegion.getType() != "PHP_CONTENT") {
            return null;
        }
        IPHPScriptRegion phpScriptRegion = (IPHPScriptRegion)tRegion;
        try {
            tRegion = phpScriptRegion.getPHPToken(offset - container.getStartOffset() - phpScriptRegion.getStart());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (tRegion == null) {
            return null;
        }
        return tRegion.getType();
    }

    public static boolean isPHPDoc(IStructuredDocument document, int offset) {
        String region = PHPDocTextSequenceUtilities.getPHPRegionType(document, offset);
        return "PHPDOC_COMMENT".equals(region) || "PHPDOC_GENERIC_TAG".equals(region);
    }

    public static String getAnnotationName(IDocument document, int offset) throws BadLocationException {
        return PHPDocTextSequenceUtilities.getAnnotationName(document, offset, document.getLength() - 1);
    }

    public static String getAnnotationName(IDocument document, int offset, int max) throws BadLocationException {
        char ch;
        if (document.getLength() < offset) {
            return null;
        }
        StringBuilder name = new StringBuilder();
        int i = offset - 1;
        while (i >= 0) {
            ch = document.getChar(i);
            if (ch == '@') break;
            if (!PHPDocTextSequenceUtilities.isIdentPart(ch)) {
                return null;
            }
            name.insert(0, ch);
            --i;
        }
        i = offset;
        while (i <= max) {
            ch = document.getChar(i);
            if (Character.isWhitespace(ch) || ch == '(') break;
            if (!PHPDocTextSequenceUtilities.isIdentPart(ch)) {
                return null;
            }
            name.append(ch);
            ++i;
        }
        return name.toString();
    }

    public static boolean isIdentPart(char ch) {
        return Character.isLetterOrDigit(ch) || ch == '\\' || ch == '_';
    }

    public static boolean isInsideAnnotation(String text, int offset) {
        int end = offset;
        if (offset >= text.length()) {
            offset = text.length() - 1;
        }
        while (end > 0 && text.charAt(end) != '@') {
            --end;
        }
        --end;
        boolean inString = false;
        boolean go = false;
        int calls = 0;
        while (!go && end > 1) {
            char ch = text.charAt(end);
            if (inString && ch == '\"' && text.charAt(end - 1) != '\\') {
                inString = false;
            } else {
                switch (ch) {
                    case '\"': {
                        inString = true;
                        break;
                    }
                    case ')': {
                        ++calls;
                        break;
                    }
                    case '(': {
                        if (calls == 0) {
                            go = true;
                            break;
                        }
                        --calls;
                    }
                }
            }
            --end;
        }
        if (--end == 1) {
            return false;
        }
        boolean noMoreWhiteSpace = false;
        while (end > 1) {
            char ch = text.charAt(end);
            if (PHPDocTextSequenceUtilities.isIdentPart(ch)) {
                noMoreWhiteSpace = true;
            } else if (noMoreWhiteSpace || !Character.isWhitespace(ch) && ch != '*') {
                return ch == '@';
            }
            --end;
        }
        return false;
    }

    public static boolean isWhiteSpace(char ch) {
        return Character.isWhitespace(ch) || ch == '*';
    }

    public static int readBackwardSpaces(TextSequence sequence, int offset) {
        while (offset > 0 && PHPDocTextSequenceUtilities.isWhiteSpace(sequence.charAt(offset - 1))) {
            --offset;
        }
        return offset;
    }

    /*
     * Unable to fully structure code
     */
    public static int findAnnotationBodyStart(TextSequence sequence, int offset) {
        while (offset >= sequence.length()) {
            --offset;
        }
        depth = 0;
        inString = false;
        if (sequence.charAt(offset) != '(') ** GOTO lbl26
        return offset - 1;
lbl-1000:
        // 1 sources

        {
            block6: {
                block7: {
                    block5: {
                        ch = sequence.charAt(offset - 1);
                        if (!inString || ch != '\"' || sequence.charAt(offset - 2) == '\\') break block5;
                        inString = false;
                        break block6;
                    }
                    if (inString || ch != '\"') break block7;
                    inString = true;
                    break block6;
                }
                if (inString || ch != '(') ** GOTO lbl22
                if (depth > 0) {
                    --depth;
                } else {
                    return offset - 1;
lbl22:
                    // 1 sources

                    if (!inString && ch == ')') {
                        ++depth;
                    }
                }
            }
            --offset;
lbl26:
            // 2 sources

            ** while (offset > 1)
        }
lbl27:
        // 1 sources

        return -1;
    }
}

