/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.doctrine.internal.core.validation.validator;

import com.dubture.doctrine.annotation.model.AnnotationBlock;
import com.dubture.doctrine.annotation.model.AnnotationClass;
import com.dubture.doctrine.annotation.model.AnnotationVisitor;
import com.dubture.doctrine.core.compiler.IAnnotationModuleDeclaration;
import com.dubture.doctrine.internal.core.validation.DoctrineProblemIdentifier;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.compiler.problem.ProblemSeverity;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.php.core.compiler.ast.nodes.ClassDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PHPFieldDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PHPMethodDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.TraitDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.core.compiler.ast.nodes.UseStatement;
import org.eclipse.php.core.compiler.ast.validator.IValidatorVisitor;
import org.eclipse.php.core.compiler.ast.visitor.PHPASTVisitor;
import org.eclipse.php.internal.core.model.PHPModelAccess;
import org.eclipse.php.internal.core.preferences.TaskPatternsProvider;

public class AnnotationValidatorVisitor
extends PHPASTVisitor {
    private static final String MESSAGE_CANNOT_RESOLVE_TYPE = "The annotation %s cannot be resolved";
    private static final String TASK_ATTRIBUTE_KEY = String.valueOf(AnnotationValidatorVisitor.class.getName()) + "_task_tags:";
    public static final String ID = "com.dubture.doctrine.core.annotationValidator";
    private IValidatorVisitor validator;
    private ISourceModule sourceModule;
    private IAnnotationModuleDeclaration annotationModuleDeclaration;
    private Map<String, String> parts;
    private Map<String, Boolean> resolved;
    private Pattern[] taskPatterns;

    public AnnotationValidatorVisitor(IBuildContext context, IValidatorVisitor validator, IAnnotationModuleDeclaration moduleDeclaration) {
        this.validator = validator;
        this.sourceModule = context.getSourceModule();
        this.annotationModuleDeclaration = moduleDeclaration;
        String taskTagsKey = String.valueOf(TASK_ATTRIBUTE_KEY) + context.getSourceModule().getScriptProject().getElementName();
        Object taskAttr = context.get(taskTagsKey);
        if (taskAttr == null) {
            this.taskPatterns = TaskPatternsProvider.getInstance().getPatternsForProject(this.sourceModule.getScriptProject().getProject());
            context.set(taskTagsKey, (Object)this.taskPatterns);
        } else {
            this.taskPatterns = (Pattern[])taskAttr;
        }
        this.parts = new HashMap<String, String>();
        this.resolved = new HashMap<String, Boolean>();
    }

    public boolean visit(UseStatement s) {
        if (s.getStatementType() != 0) {
            return false;
        }
        for (UsePart part : s.getParts()) {
            if (part.getNamespace() == null) continue;
            String fullName = part.getNamespace().getFullyQualifiedName();
            this.parts.put(part.getAlias() == null ? part.getNamespace().getName().toLowerCase() : part.getAlias().getName().toLowerCase(), fullName);
        }
        return false;
    }

    public boolean visit(NamespaceDeclaration s) throws Exception {
        this.parts = new HashMap<String, String>();
        return super.visit(s);
    }

    public boolean visit(ClassDeclaration classDeclaration) throws Exception {
        this.checkAnnotation((ASTNode)classDeclaration);
        return true;
    }

    public boolean visit(PHPFieldDeclaration s) throws Exception {
        this.checkAnnotation((ASTNode)s);
        return super.visit(s);
    }

    public boolean visit(TraitDeclaration s) throws Exception {
        this.checkAnnotation((ASTNode)s);
        return super.visit(s);
    }

    public boolean visit(PHPMethodDeclaration methodDeclaration) throws Exception {
        this.checkAnnotation((ASTNode)methodDeclaration);
        return true;
    }

    public boolean visit(UsePart part) {
        return true;
    }

    private void checkAnnotation(ASTNode node) {
        AnnotationBlock annotations = this.annotationModuleDeclaration.readAnnotations(node);
        if (annotations.isEmpty()) {
            return;
        }
        annotations.traverse(new AnnotationVisitor(){

            public boolean visit(AnnotationClass node) {
                String fullName;
                if (node.getClassName().length() == 0) {
                    return true;
                }
                if (Character.isLowerCase(node.getClassName().charAt(0))) {
                    return true;
                }
                if (node.hasNamespace() && !AnnotationValidatorVisitor.this.parts.containsKey(node.getFirstNamespacePart().toLowerCase())) {
                    AnnotationValidatorVisitor.this.validator.reportProblem(node.getSourcePosition().startOffset + 1, node.getSourcePosition().endOffset + 1, String.format(AnnotationValidatorVisitor.MESSAGE_CANNOT_RESOLVE_TYPE, node.getFullyQualifiedName()), (IProblemIdentifier)DoctrineProblemIdentifier.UNRESOVABLE, ProblemSeverity.ERROR);
                    return true;
                }
                if (!node.hasNamespace()) {
                    String toMatch = String.valueOf('@') + node.getClassName();
                    Pattern[] patternArray = AnnotationValidatorVisitor.this.taskPatterns;
                    int n = AnnotationValidatorVisitor.this.taskPatterns.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Pattern taskPattern = patternArray[n2];
                        if (taskPattern.matcher(toMatch).matches()) {
                            return true;
                        }
                        ++n2;
                    }
                    if (AnnotationValidatorVisitor.this.parts.containsKey(node.getClassName().toLowerCase())) {
                        fullName = AnnotationValidatorVisitor.this.parts.get(node.getClassName().toLowerCase());
                    } else {
                        if ("Annotation".equals(node.getClassName())) {
                            return true;
                        }
                        fullName = "Doctrine\\Common\\Annotations\\Annotation\\" + node.getClassName();
                    }
                } else {
                    fullName = String.valueOf(AnnotationValidatorVisitor.this.parts.get(node.getFirstNamespacePart().toLowerCase())) + '\\' + node.getClassName();
                }
                String lower = fullName.toLowerCase();
                if (!AnnotationValidatorVisitor.this.resolved.containsKey(lower)) {
                    IDLTKSearchScope searchScope = SearchEngine.createSearchScope((IModelElement)AnnotationValidatorVisitor.this.sourceModule.getScriptProject());
                    IType[] types = PHPModelAccess.getDefault().findTypes(fullName, ISearchEngine.MatchRule.EXACT, 0, 0, searchScope, (IProgressMonitor)new NullProgressMonitor());
                    AnnotationValidatorVisitor.this.resolved.put(lower, types.length > 0);
                }
                if (!AnnotationValidatorVisitor.this.resolved.get(lower).booleanValue()) {
                    AnnotationValidatorVisitor.this.validator.reportProblem(node.getSourcePosition().startOffset + 1, node.getSourcePosition().endOffset + 1, String.format(AnnotationValidatorVisitor.MESSAGE_CANNOT_RESOLVE_TYPE, node.getFullyQualifiedName()), (IProblemIdentifier)DoctrineProblemIdentifier.UNRESOVABLE, ProblemSeverity.ERROR);
                }
                return super.visit(node);
            }
        });
    }
}

