/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.doctrine.internal.core.validation.validator;

import com.dubture.doctrine.annotation.model.AnnotationBlock;
import com.dubture.doctrine.annotation.model.AnnotationClass;
import com.dubture.doctrine.annotation.model.AnnotationVisitor;
import com.dubture.doctrine.core.AnnotationParserUtil;
import com.dubture.doctrine.core.DoctrineNature;
import com.dubture.doctrine.core.compiler.IAnnotationModuleDeclaration;
import com.dubture.doctrine.core.log.Logger;
import com.dubture.doctrine.internal.core.validation.validator.AnnotationValidatorVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.php.core.compiler.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PHPModuleDeclaration;
import org.eclipse.php.core.compiler.ast.validator.IValidatorExtension;
import org.eclipse.php.core.compiler.ast.validator.IValidatorVisitor;

public class PHPValidatorExtension
implements IValidatorExtension {
    private IBuildContext context;
    private IValidatorVisitor validator;
    private IAnnotationModuleDeclaration annotationModule;

    public void visit(ASTNode s) throws Exception {
    }

    public void endvisit(ASTNode s) throws Exception {
        if (s instanceof PHPModuleDeclaration) {
            if (!this.validator.hasNamespace()) {
                this.validate(s.sourceStart(), s.sourceEnd());
            }
            if (this.annotationModule != null) {
                s.traverse((ASTVisitor)new AnnotationValidatorVisitor(this.context, this.validator, this.annotationModule));
            }
        } else if (s instanceof NamespaceDeclaration) {
            this.validate(s.sourceStart(), s.sourceEnd());
        }
    }

    protected void validate(int start, int end) throws CoreException {
        AnnotationVisitor visitor = new AnnotationVisitor(){

            public boolean visit(AnnotationClass node) {
                IValidatorVisitor.IUsePartInfo usePartInfo = PHPValidatorExtension.this.validator.getUsePartInfo((node.getFirstNamespacePart() == null ? node.getClassName() : node.getFirstNamespacePart()).toLowerCase());
                if (usePartInfo != null) {
                    usePartInfo.increaseRefCount();
                }
                return super.visit(node);
            }
        };
        AnnotationBlock[] annotationBlockArray = this.annotationModule.getBlocks();
        int n = annotationBlockArray.length;
        int n2 = 0;
        while (n2 < n) {
            AnnotationBlock block = annotationBlockArray[n2];
            if (block.getSourcePosition().startOffset >= start && block.getSourcePosition().endOffset <= end) {
                block.traverse(visitor);
            }
            ++n2;
        }
    }

    public void init(IBuildContext buildContext, IValidatorVisitor validator) {
        this.context = buildContext;
        this.validator = validator;
        try {
            this.annotationModule = AnnotationParserUtil.getModule(this.context.getSourceModule());
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
    }

    public boolean isSupported(IBuildContext buildContext) {
        try {
            return buildContext.getSourceModule().getScriptProject().getProject().hasNature(DoctrineNature.NATURE_ID);
        }
        catch (CoreException e) {
            Logger.logException(e);
            return false;
        }
    }

    public boolean skipProblem(int start, int end, String message, IProblemIdentifier id) {
        return false;
    }

    public boolean skipProblem(ASTNode node, String message, IProblemIdentifier id) {
        return false;
    }
}

