/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.doctrine.ui.contentassist;

import java.util.function.Supplier;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.internal.core.codeassist.AliasType;
import org.eclipse.php.internal.core.codeassist.ProposalExtraInfo;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.contentassist.AutoActivationTrigger;
import org.eclipse.php.internal.ui.editor.contentassist.PHPCompletionProposal;
import org.eclipse.swt.graphics.Image;

public class DoctrineCompletionProposal
extends PHPCompletionProposal {
    private static final String EMPTY_STRING = "";
    private static final String DOUBLE_COLON = "::";
    private IDocument document;
    private ISourceModule sourceModule;
    private boolean fReplacementStringComputed = false;
    private CompletionProposal typeProposal;

    public DoctrineCompletionProposal(CompletionProposal typeProposal, IDocument document, ISourceModule cu, String replacementString, int replacementOffset, int replacementLength, final Image image, String displayString, int relevance) {
        super(replacementString, replacementOffset, replacementLength, (Supplier)new Supplier<Image>(){

            @Override
            public Image get() {
                return image;
            }
        }, new StyledString(displayString), relevance);
        this.typeProposal = typeProposal;
        this.sourceModule = cu;
        this.document = document;
    }

    public void apply(IDocument document, char trigger, int offset) {
        boolean enableAutoactivation;
        String replacementString = this.getReplacementString();
        char lastChar = replacementString.charAt(replacementString.length() - 1);
        if ((lastChar == '\\' || lastChar == '\"' || lastChar == '=') && (enableAutoactivation = Platform.getPreferencesService().getBoolean("org.eclipse.php.core", "contentAssistAutoactivation", false, null))) {
            AutoActivationTrigger.register((IDocument)document);
        }
        super.apply(document, trigger, offset);
    }

    public String getReplacementString() {
        if (!this.fReplacementStringComputed) {
            String replacementString = this.computeReplacementString();
            if (ProposalExtraInfo.isAddQuote((Object)this.typeProposal.getExtraInfo())) {
                replacementString = "'" + replacementString + "'";
            }
            this.setReplacementString(replacementString);
        }
        return super.getReplacementString();
    }

    private String computeReplacementString() {
        this.fReplacementStringComputed = true;
        IType type = (IType)this.typeProposal.getModelElement();
        if (ProposalExtraInfo.isMemberInNamespace((Object)this.typeProposal.getExtraInfo())) {
            return PHPModelUtils.getFullName((IType)type);
        }
        String prefix = EMPTY_STRING;
        try {
            int flags = type.getFlags();
            IType currentNamespace = PHPModelUtils.getCurrentNamespaceIfAny((ISourceModule)this.sourceModule, (int)this.getReplacementOffset());
            IType namespace = PHPModelUtils.getCurrentNamespace((IModelElement)type);
            if (!PHPFlags.isNamespace((int)flags) && namespace == null && currentNamespace != null && !ProjectOptions.getPHPVersion((IProject)this.sourceModule.getScriptProject().getProject()).isLessThan(PHPVersion.PHP5_3) && this.document.getChar(this.getReplacementOffset() - 1) != '\\') {
                prefix = String.valueOf(prefix) + '\\';
            }
        }
        catch (ModelException e) {
            PHPUiPlugin.log((Throwable)e);
        }
        catch (BadLocationException e) {
            PHPUiPlugin.log((Throwable)e);
        }
        String suffix = this.getSuffix(type);
        String replacementString = null;
        replacementString = this.typeProposal.getModelElement() instanceof AliasType ? String.valueOf(((AliasType)this.typeProposal.getModelElement()).getAlias()) + this.typeProposal.getCompletion().substring(this.typeProposal.getName().length()) : super.getReplacementString();
        return String.valueOf(prefix) + replacementString + suffix;
    }

    public String getSuffix(IType type) {
        String defaultResult = EMPTY_STRING;
        boolean cfr_ignored_0 = type instanceof AliasType;
        if (!ProposalExtraInfo.isTypeOnly((Object)this.typeProposal.getExtraInfo())) {
            PHPModelUtils.hasStaticOrConstMember((IType)type);
        }
        return defaultResult;
    }

    public Object getExtraInfo() {
        return this.typeProposal.getExtraInfo();
    }
}

