/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.doctrine.ui.editor.highlighting;

import com.dubture.doctrine.annotation.model.Annotation;
import com.dubture.doctrine.annotation.parser.antlr.SourcePosition;
import com.dubture.doctrine.core.AnnotationParserUtil;
import com.dubture.doctrine.core.compiler.IAnnotationModuleDeclaration;
import com.dubture.doctrine.ui.log.Logger;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticApply;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticHighlighting;
import org.eclipse.swt.graphics.RGB;

public class AnnotationHighlighting
extends AbstractSemanticHighlighting {
    public String getDisplayName() {
        return "Annotations";
    }

    public AbstractSemanticApply getSemanticApply() {
        return new AnnotationApply();
    }

    public void initDefaultPreferences() {
        this.getStyle().setUnderlineByDefault(false).setDefaultTextColor(new RGB(64, 64, 64));
    }

    public int getPriority() {
        return 200;
    }

    protected class AnnotationApply
    extends AbstractSemanticApply {
        protected ISourceModule sourceModule;
        protected IAnnotationModuleDeclaration decl;

        public AnnotationApply() {
            this.sourceModule = AnnotationHighlighting.this.getSourceModule();
            try {
                this.decl = AnnotationParserUtil.getModule((ISourceModule)this.sourceModule);
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }

        public boolean visit(Program program) {
            if (this.decl == null) {
                return false;
            }
            try {
                AnnotationHighlighting.this.getSourceModule().accept(new IModelElementVisitor(){

                    public boolean visit(IModelElement element) {
                        if (element instanceof ISourceReference) {
                            List annotations = AnnotationApply.this.decl.readAnnotations((ISourceReference)element).getAnnotations();
                            for (Annotation annotation : annotations) {
                                SourcePosition sourcePosition = annotation.getSourcePosition();
                                AnnotationHighlighting.this.highlight(sourcePosition.startOffset, sourcePosition.length);
                            }
                        }
                        return true;
                    }
                });
            }
            catch (ModelException e) {
                org.eclipse.php.internal.ui.Logger.logException((Throwable)e);
            }
            return false;
        }
    }
}

