/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.doctrine.ui.handler;

import com.dubture.doctrine.core.DoctrineNature;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class RemoveDoctrineSupportHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IAdaptable adaptable;
        IProject project;
        Object item;
        ISelection selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (selection instanceof IStructuredSelection && (item = ((IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable && (project = ((IResource)(adaptable = (IAdaptable)item).getAdapter(IResource.class)).getProject()) != null && project.exists()) {
            new Job("Remove Doctrine Support"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
                        IProjectDescription description = project.getDescription();
                        String[] natures = description.getNatureIds();
                        sub.worked(1);
                        int i = 0;
                        while (i < natures.length) {
                            if (DoctrineNature.NATURE_ID.equals(natures[i])) {
                                String[] newNatures = new String[natures.length - 1];
                                System.arraycopy(natures, 0, newNatures, 0, i);
                                System.arraycopy(natures, i + 1, newNatures, i, natures.length - i - 1);
                                description.setNatureIds(newNatures);
                                sub.worked(1);
                                project.setDescription(description, (IProgressMonitor)sub.split(1));
                                if (!monitor.isCanceled()) {
                                    project.build(15, (IProgressMonitor)sub.split(1));
                                }
                                if (!monitor.isCanceled()) {
                                    project.build(6, (IProgressMonitor)sub.split(1));
                                }
                                if (!monitor.isCanceled()) {
                                    sub.done();
                                }
                                break;
                            }
                            ++i;
                        }
                    }
                    catch (CoreException e) {
                        new Status(4, "com.dubture.doctrine.ui", e.getMessage(), (Throwable)e);
                    }
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
        return null;
    }
}

