/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.doctrine.ui.log;

import com.dubture.doctrine.core.DoctrineCorePlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.ast.ASTNode;
import org.osgi.framework.Bundle;

public class Logger {
    private static final String PLUGIN_ID = "com.dubture.doctrine.ui";
    private static final String TRACEFILTER_LOCATION = "/debug";
    public static final int OK = 0;
    public static final int INFO = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 4;
    public static final int OK_DEBUG = 200;
    public static final int INFO_DEBUG = 201;
    public static final int WARNING_DEBUG = 202;
    public static final int ERROR_DEBUG = 204;

    protected static void _log(int level, String message, Throwable exception) {
        if (!(level != 200 && level != 201 && level != 202 && level != 204 || Logger.isDebugging())) {
            return;
        }
        int severity = 0;
        switch (level) {
            case 1: 
            case 201: {
                severity = 1;
                break;
            }
            case 2: 
            case 202: {
                severity = 2;
                break;
            }
            case 4: 
            case 204: {
                severity = 4;
            }
        }
        message = message != null ? message : "null";
        Status statusObj = new Status(severity, PLUGIN_ID, severity, message, exception);
        Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
        if (bundle != null) {
            Platform.getLog((Bundle)bundle).log((IStatus)statusObj);
        }
        Logger.debugMSG(statusObj.toString());
    }

    protected static void _trace(String category, String message, Throwable exception) {
        if (Logger.isTracing(category)) {
            message = message != null ? message : "null";
            Status statusObj = new Status(0, PLUGIN_ID, 0, message, exception);
            Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
            if (bundle != null) {
                Platform.getLog((Bundle)bundle).log((IStatus)statusObj);
            }
        }
    }

    public static boolean isDebugging() {
        return Platform.inDebugMode();
    }

    public static boolean isTracing(String category) {
        if (!Logger.isDebugging()) {
            return false;
        }
        String traceFilter = Platform.getDebugOption((String)"com.dubture.doctrine.ui/debug");
        return traceFilter != null;
    }

    public static void log(int level, String message) {
        Logger._log(level, message, null);
    }

    public static void log(int level, String message, Throwable exception) {
        Logger._log(level, message, exception);
    }

    public static void logException(String message, Throwable exception) {
        Logger._trace("ERROR", message, exception);
    }

    public static void logException(Throwable exception) {
        Logger._trace("Error", exception.getMessage(), exception);
    }

    public static void traceException(String category, String message, Throwable exception) {
        Logger._trace(category, message, exception);
    }

    public static void traceException(String category, Throwable exception) {
        Logger._trace(category, exception.getMessage(), exception);
    }

    public static void trace(String category, String message) {
        Logger._trace(category, message, null);
    }

    public static void debugMSG(String msg) {
        if (DoctrineCorePlugin.debug()) {
            System.out.println(msg);
        }
    }

    public static void debugMSG(Class<? extends ASTNode> class1) {
        Logger.debugMSG(class1.toString());
    }
}

