/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.doctrine.ui.search;

import com.dubture.doctrine.annotation.model.AnnotationBlock;
import com.dubture.doctrine.annotation.model.AnnotationClass;
import com.dubture.doctrine.annotation.model.AnnotationVisitor;
import com.dubture.doctrine.core.AnnotationParserUtil;
import com.dubture.doctrine.core.compiler.IAnnotationModuleDeclaration;
import com.dubture.doctrine.ui.log.Logger;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.index2.search.ModelAccess;
import org.eclipse.dltk.ui.search.ElementQuerySpecification;
import org.eclipse.dltk.ui.search.IMatchPresentation;
import org.eclipse.dltk.ui.search.IQueryParticipant;
import org.eclipse.dltk.ui.search.ISearchRequestor;
import org.eclipse.dltk.ui.search.QuerySpecification;
import org.eclipse.php.internal.core.PHPLanguageToolkit;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.search.ui.text.Match;

public class AnnotationSearchParticipant
implements IQueryParticipant {
    public void search(final ISearchRequestor requestor, QuerySpecification querySpecification, IProgressMonitor monitor) throws CoreException {
        final HashSet list = new HashSet();
        if (querySpecification.getLimitTo() != 1 && querySpecification.getLimitTo() != 2) {
            return;
        }
        if (querySpecification instanceof ElementQuerySpecification) {
            final IModelElement searchElement = ((ElementQuerySpecification)querySpecification).getElement();
            if (!(searchElement instanceof IType)) {
                return;
            }
            String fFullName = PHPModelUtils.getFullName((IType)((IType)searchElement));
            int i = fFullName.lastIndexOf(92);
            ISearchEngine engine = ModelAccess.getSearchEngine((IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
            String qualifier = null;
            String name = fFullName;
            if (i != -1) {
                qualifier = name.substring(0, i);
                name = name.substring(i + 1);
            }
            monitor.subTask("Search references");
            engine.search(7, qualifier, name, 0, 0, 0, ISearchEngine.SearchFor.REFERENCES, ISearchEngine.MatchRule.EXACT, querySpecification.getScope(), new org.eclipse.dltk.core.index2.search.ISearchRequestor(){

                public void match(int elementType, int flags, int offset, int length, int nameOffset, int nameLength, String elementName, String metadata, String doc, String qualifier, String parent, ISourceModule sourceModule, boolean isReference) {
                    list.add(sourceModule);
                }
            }, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            monitor.subTask("Detect annotations");
            for (final ISourceModule module : list) {
                IAnnotationModuleDeclaration mod;
                ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)module);
                if (moduleDeclaration == null || (mod = AnnotationParserUtil.getModule((ISourceModule)module)) == null) continue;
                module.accept(new IModelElementVisitor(){

                    public boolean visit(final IModelElement element) {
                        if (element instanceof ISourceReference) {
                            AnnotationBlock annotations = mod.readAnnotations((ISourceReference)element);
                            annotations.traverse(new AnnotationVisitor(){

                                public boolean visit(AnnotationClass node) {
                                    try {
                                        IModelElement[] codeSelect;
                                        IModelElement[] iModelElementArray = codeSelect = module.codeSelect(node.getSourcePosition().startOffset + 1, node.getSourcePosition().length - 1);
                                        int n = codeSelect.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            IModelElement selected = iModelElementArray[n2];
                                            if (selected.equals(searchElement)) {
                                                requestor.reportMatch(new Match((Object)element, node.getSourcePosition().startOffset, node.getSourcePosition().length));
                                            }
                                            ++n2;
                                        }
                                    }
                                    catch (ModelException e) {
                                        Logger.logException(e);
                                    }
                                    return true;
                                }
                            });
                        }
                        return true;
                    }
                });
            }
        }
    }

    public int estimateTicks(QuerySpecification specification) {
        return 100;
    }

    public IMatchPresentation getUIParticipant() {
        return null;
    }
}

