/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.doctrine.ui.templates;

import com.dubture.doctrine.ui.DoctrineUIPlugin;
import com.dubture.doctrine.ui.templates.CodeTemplateContext;
import com.dubture.doctrine.ui.templates.ProjectTemplateStore;
import java.io.IOException;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.corext.util.Strings;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class StubUtility {
    public static String getGetterComment(IScriptProject sp, String typeName, String methodName, String fieldName, String fieldType, String bareFieldName, String lineDelimiter) throws CoreException {
        String templateName = "com.dubture.doctrine.codetemplates.gettercomment";
        Template template = StubUtility.getCodeTemplate(templateName, sp);
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), sp, lineDelimiter);
        context.setVariable("field_name", fieldType);
        context.setVariable("bare_field_name", bareFieldName);
        return StubUtility.evaluateTemplate(context, template);
    }

    private static Template getCodeTemplate(String id, IScriptProject sp) {
        if (sp == null) {
            return DoctrineUIPlugin.getDefault().getCodeTemplateStore().findTemplateById(id);
        }
        ProjectTemplateStore projectStore = new ProjectTemplateStore(sp.getProject());
        try {
            projectStore.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return projectStore.findTemplateById(id);
    }

    private static String evaluateTemplate(CodeTemplateContext context, Template template) throws CoreException {
        TemplateBuffer buffer;
        try {
            buffer = context.evaluate(template);
        }
        catch (BadLocationException e) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException e) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (buffer == null) {
            return null;
        }
        String str = buffer.getString();
        if (Strings.containsOnlyWhitespaces((String)str)) {
            return null;
        }
        return str;
    }

    private static String evaluateTemplate(CodeTemplateContext context, Template template, String[] fullLineVariables) throws CoreException {
        String str;
        block6: {
            TemplateBuffer buffer;
            block5: {
                buffer = context.evaluate(template);
                if (buffer != null) break block5;
                return null;
            }
            str = StubUtility.fixEmptyVariables(buffer, fullLineVariables);
            if (!Strings.containsOnlyWhitespaces((String)str)) break block6;
            return null;
        }
        try {
            return str;
        }
        catch (BadLocationException e) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException e) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
    }

    private static String fixEmptyVariables(TemplateBuffer buffer, String[] variables) throws MalformedTreeException, BadLocationException {
        Document doc = new Document(buffer.getString());
        int nLines = doc.getNumberOfLines();
        MultiTextEdit edit = new MultiTextEdit();
        HashSet<Integer> removedLines = new HashSet<Integer>();
        int i = 0;
        while (i < variables.length) {
            TemplateVariable position = StubUtility.findVariable(buffer, variables[i]);
            if (position != null && position.getLength() <= 0) {
                int[] offsets = position.getOffsets();
                int k = 0;
                while (k < offsets.length) {
                    int line = doc.getLineOfOffset(offsets[k]);
                    IRegion lineInfo = doc.getLineInformation(line);
                    int offset = lineInfo.getOffset();
                    String str = doc.get(offset, lineInfo.getLength());
                    if (Strings.containsOnlyWhitespaces((String)str) && nLines > line + 1 && removedLines.add(new Integer(line))) {
                        int nextStart = doc.getLineOffset(line + 1);
                        edit.addChild((TextEdit)new DeleteEdit(offset, nextStart - offset));
                    }
                    ++k;
                }
            }
            ++i;
        }
        edit.apply((IDocument)doc, 0);
        return doc.get();
    }

    private static TemplateVariable findVariable(TemplateBuffer buffer, String variable) {
        TemplateVariable[] positions = buffer.getVariables();
        int i = 0;
        while (i < positions.length) {
            TemplateVariable curr = positions[i];
            if (variable.equals(curr.getType())) {
                return curr;
            }
            ++i;
        }
        return null;
    }
}

