/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.core;

import com.dubture.symfony.core.log.Logger;
import com.dubture.symfony.index.SymfonyIndexer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.BundleContext;

public class SymfonyCorePlugin
extends Plugin {
    public static String ID = "com.dubture.symfony.core";
    private static SymfonyCorePlugin plugin;
    protected ScopedPreferenceStore prefStore = null;
    private static final String isDebugMode = "com.dubture.symfony.core/debug";

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IResourceChangeListener listener = new IResourceChangeListener(){

                public void resourceChanged(IResourceChangeEvent event) {
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    try {
                        SymfonyIndexer indexer = SymfonyIndexer.getInstance();
                        IProject[] iProjectArray = workspace.getRoot().getProjects();
                        int n = iProjectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProject project = iProjectArray[n2];
                            indexer.deleteServices(project.getFullPath().toString());
                            ++n2;
                        }
                    }
                    catch (Exception e) {
                        Logger.logException(e);
                    }
                }
            };
            workspace.addResourceChangeListener(listener, 8);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
        plugin = null;
    }

    public static SymfonyCorePlugin getDefault() {
        return plugin;
    }

    public static boolean debug() {
        String debugOption = Platform.getDebugOption((String)isDebugMode);
        return SymfonyCorePlugin.getDefault().isDebugging() && "true".equalsIgnoreCase(debugOption);
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.prefStore == null) {
            this.prefStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, ID);
        }
        return this.prefStore;
    }
}

