/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.core.builder;

import com.dubture.symfony.core.SymfonyCorePlugin;
import com.dubture.symfony.core.builder.SymfonyNature;
import com.dubture.symfony.core.log.Logger;
import com.dubture.symfony.core.parser.XMLConfigParser;
import com.dubture.symfony.core.parser.YamlConfigParser;
import com.dubture.symfony.core.parser.YamlRoutingParser;
import com.dubture.symfony.core.parser.YamlTranslationParser;
import com.dubture.symfony.core.preferences.CorePreferenceConstants;
import com.dubture.symfony.core.preferences.ProjectOptions;
import com.dubture.symfony.core.util.TranslationUtils;
import com.dubture.symfony.index.SymfonyIndexer;
import com.dubture.symfony.index.model.Route;
import com.dubture.symfony.index.model.RoutingResource;
import com.dubture.symfony.index.model.Service;
import com.dubture.symfony.index.model.TransUnit;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public abstract class AbstractSymfonyVisitor {
    protected IFile file;
    protected IPath path;
    protected SymfonyIndexer indexer;
    protected int timestamp;
    protected JSONArray syntheticServices;

    protected boolean handleResource(IResource resource) throws Exception {
        boolean built = false;
        if (resource instanceof IProject || resource instanceof IFolder) {
            return resource.getProject().hasNature(SymfonyNature.NATURE_ID);
        }
        if (!(resource instanceof IFile)) {
            return false;
        }
        IScriptProject scriptProject = DLTKCore.create((IProject)resource.getProject());
        boolean isOnBuildPath = scriptProject.isOnBuildpath(resource);
        this.indexer = SymfonyIndexer.getInstance();
        this.file = (IFile)resource;
        this.path = resource.getFullPath();
        this.timestamp = (int)resource.getLocalTimeStamp();
        IEclipsePreferences node = new ProjectScope(scriptProject.getProject()).getNode(SymfonyCorePlugin.ID);
        String container = node.get(CorePreferenceConstants.Keys.DUMPED_CONTAINER, null);
        if (container != null && resource.getFullPath().removeFirstSegments(1).equals((Object)new Path(container))) {
            this.loadDumpedXmlContainer(resource);
            built = true;
        } else if ("xml".equals(resource.getFileExtension()) && isOnBuildPath) {
            this.loadXML(resource);
            built = true;
        } else if ("yml".equals(resource.getFileExtension()) && isOnBuildPath) {
            if (resource.getName().contains("routing")) {
                this.loadYamlRouting();
                built = true;
            } else if (resource.getFullPath().toString().contains("translations")) {
                this.loadYamlTranslation();
            }
        }
        return built;
    }

    protected void loadYamlTranslation() throws Exception {
        YamlTranslationParser parser = new YamlTranslationParser(this.file.getContents());
        parser.parse();
        String lang = TranslationUtils.getLanguageFromFilename(this.file.getName());
        Map<String, String> transUnits = parser.getTranslations();
        Iterator<String> it = transUnits.keySet().iterator();
        ArrayList<TransUnit> translations = new ArrayList<TransUnit>();
        while (it.hasNext()) {
            String key = it.next();
            String value = transUnits.get(key);
            TransUnit unit = new TransUnit(key, value, lang);
            translations.add(unit);
        }
        this.indexTranslations(translations);
    }

    protected JSONArray getSynthetics() {
        if (this.syntheticServices == null) {
            this.syntheticServices = ProjectOptions.getSyntheticServices(this.file.getProject());
        }
        return this.syntheticServices;
    }

    protected void loadYamlRouting() throws CoreException {
        YamlRoutingParser parser = new YamlRoutingParser(this.file.getContents());
        parser.parse();
        this.indexRoutes(parser.getRoutes());
        this.indexResources(parser.getResources());
    }

    protected void indexTranslations(List<TransUnit> translations) {
        for (TransUnit unit : translations) {
            this.indexer.addTranslation(unit, this.file.getFullPath().toString(), this.timestamp);
            Logger.debugMSG(String.format("indexing translational: %s", unit.toString()));
        }
        this.indexer.exitTranslations();
    }

    protected void indexRoutes(Stack<Route> routes) {
        for (Route route : routes) {
            this.indexer.addRoute(route, this.file.getProject().getFullPath());
        }
        this.indexer.exitRoutes();
    }

    protected void indexResources(Stack<RoutingResource> resources) {
        for (RoutingResource resource : resources) {
            Logger.debugMSG("indexing resource: " + resource.toString());
            this.indexer.addResource(resource, this.file.getProject().getFullPath());
        }
        this.indexer.exitResources();
    }

    protected void loadYaml() throws Exception {
        YamlConfigParser parser = new YamlConfigParser(this.file.getContents());
        parser.parse();
        this.indexServices(parser.getServices());
    }

    protected void loadDumpedXmlContainer(IResource resource) throws Exception {
        FileInputStream fis = new FileInputStream(this.file.getLocation().toFile());
        XMLConfigParser parser = new XMLConfigParser(fis);
        parser.parse();
        this.indexServices(parser.getServices());
        this.indexParameters(parser.getParameters());
    }

    private void indexParameters(HashMap<String, String> parameters) {
        for (String key : parameters.keySet()) {
            String value = parameters.get(key);
            if (key.isEmpty() || value.isEmpty()) continue;
            try {
                this.indexer.addParameter(key, value, this.path);
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }
    }

    protected void loadXML(IResource resource) {
        try {
            FileInputStream fis = new FileInputStream(this.file.getLocation().toFile());
            XMLConfigParser parser = new XMLConfigParser(fis);
            parser.parse();
            if (parser.hasRoutes()) {
                this.indexRoutes(parser.getRoutes());
            }
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    protected void indexServices(HashMap<String, Service> services) {
        this.indexer.enterServices(this.path.toString());
        Iterator<String> it = services.keySet().iterator();
        JSONArray synths = this.getSynthetics();
        while (it.hasNext()) {
            String id = it.next();
            Service service = services.get(id);
            if (service == null) {
                Logger.log(2, "error parsing service " + id);
                continue;
            }
            if (service.phpClass != null && "synthetic".equals(service.phpClass)) {
                for (Object o : synths) {
                    JSONObject _s = (JSONObject)o;
                    if (!_s.get((Object)"name").equals(id)) continue;
                    service.phpClass = (String)_s.get((Object)"class");
                    break;
                }
            }
            String _pub = service.isPublic() ? "true" : "false";
            this.indexer.addService(id, service.phpClass, _pub, service.getTags(), this.path.toString(), this.timestamp);
        }
        this.indexer.exitServices();
    }
}

