/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.core.codeassist;

import com.dubture.symfony.core.model.Bundle;
import com.dubture.symfony.core.model.Controller;
import com.dubture.symfony.core.model.SymfonyModelAccess;
import com.dubture.symfony.core.model.Template;
import com.dubture.symfony.core.model.Translation;
import com.dubture.symfony.core.model.ViewPath;
import com.dubture.symfony.index.model.TransUnit;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.php.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.model.PHPModelAccess;

public class CodeassistUtils {
    public static void reportTranslations(ICompletionReporter reporter, String prefix, ISourceRange range, IScriptProject project) {
        SymfonyModelAccess model = SymfonyModelAccess.getDefault();
        List<Bundle> bundles = model.findBundles(project);
        List<TransUnit> units = model.findTranslations(project.getPath());
        for (TransUnit unit : units) {
            Bundle targetBundle = null;
            for (Bundle bundle : bundles) {
                if (!unit.path.startsWith(bundle.getTranslationPath())) continue;
                targetBundle = bundle;
                break;
            }
            if (targetBundle.getScriptProject() == null) {
                targetBundle.setProject(project);
            }
            if (targetBundle == null || !StringUtils.startsWithIgnoreCase((CharSequence)unit.name, (CharSequence)prefix)) continue;
            Translation trans = new Translation((ModelElement)targetBundle, unit);
            reporter.reportType((IType)trans, "", range);
        }
    }

    public static void reportViewpath(ICompletionReporter reporter, ViewPath viewPath, String prefix, ISourceRange range, IScriptProject project) {
        block12: {
            IModelElement[] templates;
            String template;
            String controller;
            String bundle;
            SymfonyModelAccess model;
            block15: {
                block14: {
                    block13: {
                        block11: {
                            model = SymfonyModelAccess.getDefault();
                            bundle = viewPath.getBundle();
                            controller = viewPath.getController();
                            template = viewPath.getTemplate();
                            IDLTKSearchScope projectScope = SearchEngine.createSearchScope((IModelElement)project);
                            if (bundle != null || controller != null || template != null) break block11;
                            List<Bundle> bundles = model.findBundles(project);
                            for (Bundle b : bundles) {
                                ModelElement bType;
                                IType[] bundleTypes = PHPModelAccess.getDefault().findTypes(b.getElementName(), ISearchEngine.MatchRule.EXACT, 0, 0, projectScope, null);
                                if (bundleTypes.length != 1 || !StringUtils.startsWithIgnoreCase((CharSequence)(bType = (ModelElement)bundleTypes[0]).getElementName(), (CharSequence)prefix)) continue;
                                Bundle bundleType = new Bundle(bType, b.getElementName());
                                reporter.reportType((IType)bundleType, ":", range);
                            }
                            break block12;
                        }
                        if (controller != null || template != null) break block13;
                        IType[] controllers = model.findBundleControllers(bundle, project);
                        for (IPath path : model.findBundleViewPaths(bundle, project)) {
                            IType t = null;
                            IType[] iTypeArray = controllers;
                            int n = controllers.length;
                            int bundleType = 0;
                            while (bundleType < n) {
                                IType type = iTypeArray[bundleType];
                                String pathString = path.removeLastSegments(path.segmentCount() - 1).toString();
                                if (type.getElementName().contains(pathString)) {
                                    t = type;
                                    break;
                                }
                                ++bundleType;
                            }
                            if (t == null) continue;
                            Controller ctrl = new Controller((ModelElement)t, path.toString());
                            reporter.reportType((IType)ctrl, ":", range);
                        }
                        break block12;
                    }
                    if (bundle == null || controller == null) break block14;
                    IModelElement[] templates2 = model.findTemplates(bundle, controller, project);
                    if (templates2 == null) break block12;
                    IModelElement[] iModelElementArray = templates2;
                    int n = templates2.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IModelElement tpl = iModelElementArray[n2];
                        if (StringUtils.startsWithIgnoreCase((CharSequence)tpl.getElementName(), (CharSequence)prefix)) {
                            Template t = new Template((ModelElement)tpl, tpl.getElementName());
                            reporter.reportType((IType)t, "", range);
                        }
                        ++n2;
                    }
                    break block12;
                }
                if (bundle != null || controller != null || template == null) break block15;
                IModelElement[] templates3 = model.findRootTemplates(project);
                if (templates3 == null) break block12;
                IModelElement[] iModelElementArray = templates3;
                int n = templates3.length;
                int n3 = 0;
                while (n3 < n) {
                    IModelElement tpl = iModelElementArray[n3];
                    if (StringUtils.startsWithIgnoreCase((CharSequence)tpl.getElementName(), (CharSequence)prefix)) {
                        Template t = new Template((ModelElement)tpl, tpl.getElementName());
                        reporter.reportType((IType)t, "", range);
                    }
                    ++n3;
                }
                break block12;
            }
            if (bundle != null && controller == null && template != null && (templates = model.findBundleRootTemplates(bundle, project)) != null) {
                IModelElement[] iModelElementArray = templates;
                int n = templates.length;
                int n4 = 0;
                while (n4 < n) {
                    IModelElement tpl = iModelElementArray[n4];
                    if (StringUtils.startsWithIgnoreCase((CharSequence)tpl.getElementName(), (CharSequence)prefix)) {
                        Template t = new Template((ModelElement)tpl, tpl.getElementName());
                        reporter.reportType((IType)t, "", range);
                    }
                    ++n4;
                }
            }
        }
    }
}

