/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.core.codeassist;

import com.dubture.doctrine.core.AnnotationParserUtil;
import com.dubture.doctrine.core.compiler.IAnnotationModuleDeclaration;
import com.dubture.symfony.core.log.Logger;
import com.dubture.symfony.core.model.Service;
import com.dubture.symfony.core.model.SymfonyModelAccess;
import com.dubture.symfony.core.model.ViewPath;
import com.dubture.symfony.core.util.text.SymfonyTextSequenceUtilities;
import com.dubture.symfony.index.model.Route;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.codeassist.ScriptSelectionEngine;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.compiler.ast.nodes.ClassDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.core.compiler.ast.nodes.PHPMethodDeclaration;
import org.eclipse.php.core.compiler.ast.visitor.PHPASTVisitor;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPHPScriptRegion;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class SymfonySelectionEngine
extends ScriptSelectionEngine {
    private static final IModelElement[] NONE = new IModelElement[0];

    public IModelElement[] select(IModuleSource sourceUnit, int offset, int end) {
        IStructuredDocument document;
        String content;
        ISourceModule sourceModule;
        block25: {
            sourceModule = (ISourceModule)sourceUnit.getModelElement();
            content = sourceUnit.getSourceContents();
            if (content.length() <= offset) {
                return NONE;
            }
            document = null;
            IStructuredModel structuredModel = null;
            try {
                try {
                    IFile file = (IFile)sourceUnit.getModelElement().getResource();
                    if (file != null) {
                        if (file.exists()) {
                            structuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(file);
                            document = structuredModel != null ? structuredModel.getStructuredDocument() : StructuredModelManager.getModelManager().createStructuredDocumentFor(file);
                        } else {
                            document = StructuredModelManager.getModelManager().createNewStructuredDocumentFor(file);
                            document.set(sourceUnit.getSourceContents());
                        }
                    }
                }
                catch (Exception e) {
                    Logger.logException(e);
                    if (structuredModel != null) {
                        structuredModel.releaseFromRead();
                    }
                    break block25;
                }
            }
            catch (Throwable throwable) {
                if (structuredModel != null) {
                    structuredModel.releaseFromRead();
                }
                throw throwable;
            }
            if (structuredModel != null) {
                structuredModel.releaseFromRead();
            }
        }
        if (document == null) {
            return NONE;
        }
        IStructuredDocumentRegion sRegion = document.getRegionAtCharacterOffset(offset);
        if (sRegion == null) {
            return NONE;
        }
        ITextRegion tRegion = sRegion.getRegionAtCharacterOffset(offset);
        IStructuredDocumentRegion container = sRegion;
        if (tRegion instanceof ITextRegionContainer) {
            container = (ITextRegionContainer)tRegion;
            tRegion = container.getRegionAtCharacterOffset(offset);
        }
        if (tRegion != null && tRegion.getType() == "PHP_CONTENT") {
            IPHPScriptRegion phpScriptRegion = (IPHPScriptRegion)tRegion;
            try {
                tRegion = phpScriptRegion.getPHPToken(offset - container.getStartOffset() - phpScriptRegion.getStart());
            }
            catch (BadLocationException badLocationException) {}
            if (tRegion == null) {
                return NONE;
            }
        }
        int startOffset = SymfonyTextSequenceUtilities.readLiteralStartIndex(content, offset);
        int endOffset = SymfonyTextSequenceUtilities.readLiteralEndIndex(content, offset);
        SymfonyModelAccess model = SymfonyModelAccess.getDefault();
        IScriptProject project = sourceModule.getScriptProject();
        if (startOffset >= 0 && endOffset != 0 && endOffset > startOffset) {
            IType serviceType;
            IMethod method;
            String literal = content.substring(startOffset, endOffset);
            Route route = model.findRoute(literal, project);
            if (route != null && (method = model.findAction(route, project)) != null) {
                return new IModelElement[]{method};
            }
            Service service = model.findService(literal, project.getPath());
            if (service != null && (serviceType = model.findServiceType(service, project)) != null) {
                return new IModelElement[]{serviceType};
            }
        }
        try {
            ModuleDeclaration parsedUnit = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule, null);
            AnnotationPathVisitor visitor = new AnnotationPathVisitor(sourceModule, offset);
            parsedUnit.traverse((ASTVisitor)visitor);
            if (visitor.getTemplate() != null) {
                return new IModelElement[]{visitor.getTemplate()};
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return NONE;
    }

    private static class AnnotationPathVisitor
    extends PHPASTVisitor {
        private static final String TEMPLATE_CLASS_NAME = "Template";
        private IScriptProject project;
        private NamespaceDeclaration namespaceDeclaration;
        private ClassDeclaration classDeclaration;
        private IModelElement template = null;
        private int offset;
        private IAnnotationModuleDeclaration annotationModule = null;

        public AnnotationPathVisitor(ISourceModule sourceModule, int offset) {
            this.project = sourceModule.getScriptProject();
            try {
                this.annotationModule = AnnotationParserUtil.getModule((ISourceModule)sourceModule);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            this.offset = offset;
        }

        public IModelElement getTemplate() {
            return this.template;
        }

        public boolean visit(NamespaceDeclaration namespaceDeclaration) throws Exception {
            this.namespaceDeclaration = namespaceDeclaration;
            return true;
        }

        public boolean visit(ClassDeclaration classDeclaration) throws Exception {
            this.classDeclaration = classDeclaration;
            return true;
        }

        public boolean visit(PHPMethodDeclaration methodDeclaration) throws Exception {
            String action;
            String controller;
            if (this.namespaceDeclaration == null || !this.namespaceDeclaration.getName().endsWith("\\Controller")) {
                return false;
            }
            PHPDocBlock phpDoc = methodDeclaration.getPHPDoc();
            if (phpDoc == null || phpDoc.sourceStart() > this.offset || phpDoc.sourceEnd() < this.offset) {
                return false;
            }
            if (this.annotationModule == null) {
                return false;
            }
            List annotations = this.annotationModule.readAnnotations((ASTNode)methodDeclaration).findAnnotations(TEMPLATE_CLASS_NAME);
            if (annotations.size() < 1) {
                return false;
            }
            String bundle = this.namespaceDeclaration.getName().replace("\\Controller", "").replace("\\", "");
            ViewPath path = new ViewPath(String.format("%s:%s:%s", bundle, controller = this.classDeclaration.getName().replace("Controller", ""), action = methodDeclaration.getName().replace("Action", "")));
            if (!path.isValid()) {
                return false;
            }
            IModelElement[] templates = SymfonyModelAccess.getDefault().findTemplates(bundle, controller, this.project);
            this.template = null;
            IModelElement[] iModelElementArray = templates;
            int n = templates.length;
            int n2 = 0;
            while (n2 < n) {
                IModelElement template = iModelElementArray[n2];
                if (template.getElementName().startsWith(action)) {
                    this.template = template;
                    return false;
                }
                ++n2;
            }
            return false;
        }
    }
}

