/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.core.codeassist.contexts;

import com.dubture.symfony.core.builder.SymfonyNature;
import com.dubture.symfony.core.codeassist.contexts.QuoteIdentifierContext;
import com.dubture.symfony.core.log.Logger;
import com.dubture.symfony.core.model.EntityAlias;
import com.dubture.symfony.core.util.text.SymfonyTextSequenceUtilities;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.internal.core.util.text.TextSequence;

public class EntityCompletionContext
extends QuoteIdentifierContext {
    private EntityAlias alias;

    public boolean isValid(ISourceModule sourceModule, int offset, CompletionRequestor requestor) {
        if (super.isValid(sourceModule, offset, requestor)) {
            TextSequence statementText;
            block12: {
                block11: {
                    block10: {
                        if (sourceModule.getScriptProject().getProject().hasNature(SymfonyNature.NATURE_ID)) break block10;
                        return false;
                    }
                    if (requestor != null && requestor.getClass().toString().toLowerCase().contains("symfony")) break block11;
                    return false;
                }
                statementText = this.getStatementText();
                char nextChar = this.getNextChar();
                if (nextChar == ' ' || nextChar == '\n' || nextChar == '\'' || nextChar == '\"') break block12;
                return false;
            }
            try {
                if (SymfonyTextSequenceUtilities.isInEntityFunctionParameter((CharSequence)statementText) > -1) {
                    int startOffset = SymfonyTextSequenceUtilities.readViewPathStartIndex((CharSequence)statementText);
                    String path = null;
                    if (startOffset == -1) {
                        path = "";
                    } else {
                        int original = statementText.getOriginalOffset(startOffset);
                        int end = offset;
                        path = original >= 0 && end > original ? statementText.getSource().getFullText().substring(original, end) : "";
                    }
                    if (path != null) {
                        this.alias = new EntityAlias(path);
                        return true;
                    }
                    return true;
                }
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }
        return false;
    }

    public EntityAlias getAlias() {
        return this.alias;
    }
}

