/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.core.codeassist.contexts;

import com.dubture.symfony.core.codeassist.contexts.QuoteIdentifierContext;
import com.dubture.symfony.core.log.Logger;
import com.dubture.symfony.core.model.ViewPath;
import com.dubture.symfony.core.util.text.SymfonyTextSequenceUtilities;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.internal.core.util.text.TextSequence;

public class ViewPathArgumentContext
extends QuoteIdentifierContext {
    private ViewPath viewPath;

    public boolean isValid(ISourceModule sourceModule, int offset, CompletionRequestor requestor) {
        if (super.isValid(sourceModule, offset, requestor)) {
            TextSequence statement;
            block9: {
                block8: {
                    if (requestor != null && requestor.getClass().toString().contains("Symfony")) break block8;
                    return false;
                }
                statement = this.getStatementText();
                IScriptProject project = this.getCompanion().getSourceModule().getScriptProject();
                if (SymfonyTextSequenceUtilities.isInViewPathFunctionParameter(statement, project)) break block9;
                return false;
            }
            try {
                int startOffset = SymfonyTextSequenceUtilities.readViewPathStartIndex((CharSequence)statement);
                String path = null;
                if (startOffset == -1) {
                    path = "";
                } else {
                    int original = statement.getOriginalOffset(startOffset);
                    int end = offset;
                    path = original >= 0 && end > original ? statement.getSource().getFullText().substring(original, end) : "";
                }
                if (path != null) {
                    this.viewPath = new ViewPath(path);
                    return true;
                }
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }
        return false;
    }

    public ViewPath getViewPath() {
        return this.viewPath;
    }
}

