/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.core.codeassist.strategies;

import com.dubture.doctrine.core.model.DoctrineModelAccess;
import com.dubture.doctrine.core.model.Entity;
import com.dubture.symfony.core.codeassist.contexts.EntityCompletionContext;
import com.dubture.symfony.core.model.Bundle;
import com.dubture.symfony.core.model.EntityAlias;
import com.dubture.symfony.core.model.SymfonyModelAccess;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.strategies.MethodParameterKeywordStrategy;
import org.eclipse.php.internal.core.model.PHPModelAccess;
import org.eclipse.php.internal.core.typeinference.IModelAccessCache;
import org.eclipse.php.internal.core.typeinference.context.IModelCacheContext;

public class EntityCompletionStrategy
extends MethodParameterKeywordStrategy {
    private static final IType[] EMPTY_TYPES = new IType[0];

    public EntityCompletionStrategy(ICompletionContext context) {
        super(context);
    }

    public void apply(ICompletionReporter reporter) throws BadLocationException {
        EntityCompletionContext context = (EntityCompletionContext)this.getContext();
        SymfonyModelAccess model = SymfonyModelAccess.getDefault();
        IScriptProject project = this.getCompanion().getSourceModule().getScriptProject();
        ISourceRange range = this.getReplacementRange((ICompletionContext)context);
        IDLTKSearchScope projectScope = SearchEngine.createSearchScope((IModelElement)this.getCompanion().getSourceModule().getScriptProject());
        DoctrineModelAccess doctrineModel = DoctrineModelAccess.getDefault();
        IModelAccessCache cache = null;
        if (context instanceof IModelCacheContext) {
            cache = ((IModelCacheContext)context).getCache();
        }
        EntityAlias alias = context.getAlias();
        String prefix = context.getPrefix();
        if (!alias.hasBundle()) {
            List<Bundle> bundles = model.findBundles(project);
            for (Bundle b : bundles) {
                ModelElement bType;
                IType[] bundleTypes = EMPTY_TYPES;
                if (cache != null) {
                    Collection types = cache.getTypes(this.getCompanion().getSourceModule(), b.getElementName(), null, null);
                    if (types != null) {
                        bundleTypes = types.toArray(new IType[types.size()]);
                    }
                } else {
                    bundleTypes = PHPModelAccess.getDefault().findTypes(b.getElementName(), ISearchEngine.MatchRule.EXACT, 0, 0, projectScope, null);
                }
                if (bundleTypes.length != 1 || !StringUtils.startsWithIgnoreCase((CharSequence)(bType = (ModelElement)bundleTypes[0]).getElementName(), (CharSequence)prefix)) continue;
                Bundle bundleType = new Bundle(bType, b.getElementName());
                reporter.reportType((IType)bundleType, ":", range);
            }
        } else {
            List entities = doctrineModel.getEntities(project);
            for (Entity entity : entities) {
                EntityAlias newAliase = new EntityAlias(alias.getBundleAlias(), entity.getElementName());
                IType type = model.findEntity(newAliase, project);
                if (type == null) continue;
                reporter.reportType((IType)new Entity((ModelElement)type, type.getElementName()), "", range);
            }
        }
    }
}

