/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.core.codeassist.strategies;

import com.dubture.symfony.core.codeassist.contexts.ServiceContainerContext;
import com.dubture.symfony.core.model.Service;
import com.dubture.symfony.core.model.SymfonyModelAccess;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.strategies.MethodParameterKeywordStrategy;

public class ServiceContainerCompletionStrategy
extends MethodParameterKeywordStrategy {
    public ServiceContainerCompletionStrategy(ICompletionContext context) {
        super(context);
    }

    public void apply(ICompletionReporter reporter) throws BadLocationException {
        ServiceContainerContext context = (ServiceContainerContext)this.getContext();
        IScriptProject project = this.getCompanion().getSourceModule().getScriptProject();
        SymfonyModelAccess model = SymfonyModelAccess.getDefault();
        List<Service> services = model.findServices(project.getPath());
        ISourceRange range = this.getReplacementRange((ICompletionContext)context);
        String prefix = context.getPrefix();
        if (services == null) {
            return;
        }
        for (Service service : services) {
            if (!StringUtils.startsWithIgnoreCase((CharSequence)service.getId(), (CharSequence)prefix)) continue;
            ModelElement parent = (ModelElement)this.getCompanion().getSourceModule();
            Service s = new Service(parent, service.getElementName());
            s.setId(service.getId());
            reporter.reportType((IType)s, "", range);
        }
    }
}

