/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.core.compiler;

import com.dubture.symfony.core.builder.SymfonyNature;
import com.dubture.symfony.core.model.SymfonyModelAccess;
import com.dubture.symfony.core.util.PathUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.php.core.compiler.PHPSourceElementRequestorExtension;
import org.eclipse.php.core.compiler.ast.nodes.ClassDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.FullyQualifiedReference;
import org.eclipse.php.core.compiler.ast.nodes.PHPMethodDeclaration;
import org.eclipse.php.internal.core.Logger;

public class SourceElementRequestor
extends PHPSourceElementRequestorExtension {
    private ClassDeclaration currentClass;
    private boolean inController;
    private SymfonyModelAccess model = SymfonyModelAccess.getDefault();
    private boolean isSymfonySource;

    public void setSourceModule(IModuleSource sourceModule) {
        super.setSourceModule(sourceModule);
        try {
            this.isSymfonySource = sourceModule.getModelElement().getScriptProject().getProject().exists() && sourceModule.getModelElement().getScriptProject().getProject().getNature(SymfonyNature.NATURE_ID) != null;
        }
        catch (CoreException e) {
            this.isSymfonySource = false;
            Logger.logException((Throwable)e);
        }
    }

    public boolean isInController() {
        return this.inController;
    }

    public boolean visit(TypeDeclaration s) throws Exception {
        if (!this.isSymfonySource) {
            return false;
        }
        if (s instanceof ClassDeclaration) {
            this.currentClass = (ClassDeclaration)s;
            for (Object o : this.currentClass.getSuperClasses().getChilds()) {
                FullyQualifiedReference superReference;
                if (!(o instanceof FullyQualifiedReference) || !(superReference = (FullyQualifiedReference)o).getName().equals("Controller")) continue;
                this.inController = true;
            }
        }
        return true;
    }

    public boolean visit(Statement st) throws Exception {
        return true;
    }

    public boolean visit(Expression st) throws Exception {
        if (!this.isSymfonySource) {
            return false;
        }
        if (st instanceof StringLiteral) {
            StringLiteral literal = (StringLiteral)st;
            String literalValue = literal.getValue().replaceAll("['\"]", "");
            PathUtils.isViewPath(literalValue);
        }
        return true;
    }

    public boolean visit(MethodDeclaration s) throws Exception {
        boolean cfr_ignored_0 = s instanceof PHPMethodDeclaration;
        return true;
    }

    public boolean endvisit(TypeDeclaration s) throws Exception {
        this.inController = false;
        this.currentClass = null;
        return true;
    }
}

