/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.core.facet;

import com.dubture.indexing.core.IndexingCorePlugin;
import com.dubture.symfony.core.SymfonyVersion;
import com.dubture.symfony.core.log.Logger;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class FacetManager {
    public static void installFacets(IProject project, PHPVersion version, SymfonyVersion symfonyVersion, IProgressMonitor monitor) {
        try {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            IFacetedProject facetedProject = null;
            boolean hasComposerFacet = false;
            Set facetedProjects = ProjectFacetsManager.getFacetedProjects();
            IProjectFacet composerFacet = ProjectFacetsManager.getProjectFacet((String)"php.composer.component");
            for (IFacetedProject fp : facetedProjects) {
                if (!project.getName().equals(fp.getProject().getName()) || !fp.hasProjectFacet(composerFacet)) continue;
                hasComposerFacet = true;
                break;
            }
            facetedProject = !hasComposerFacet ? org.eclipse.php.composer.core.facet.FacetManager.installFacets((IProject)project, (PHPVersion)version, (IProgressMonitor)monitor) : ProjectFacetsManager.create((IProject)project);
            if (facetedProject == null) {
                Logger.log(2, "Could not retrieve a symfony faceted project to install the facet.");
                return;
            }
            IProjectFacet symfonyFacet = ProjectFacetsManager.getProjectFacet((String)"php.symfony.component");
            switch (symfonyVersion) {
                case Symfony2_1_9: {
                    facetedProject.installProjectFacet(symfonyFacet.getVersion("2.1"), (Object)symfonyFacet, monitor);
                    break;
                }
                case Symfony2_2_1: {
                    facetedProject.installProjectFacet(symfonyFacet.getVersion("2.2"), (Object)symfonyFacet, monitor);
                    break;
                }
            }
            IndexingCorePlugin.getDefault().setupBuilder(project);
        }
        catch (Exception ex) {
            Logger.logException(ex.getMessage(), ex);
        }
    }

    public static void uninstallFacets(IProject project, IProgressMonitor monitor) {
        try {
            if (project == null) {
                return;
            }
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            IProjectFacet symfonyFacet = ProjectFacetsManager.getProjectFacet((String)"php.symfony.component");
            Set facetedProjects = ProjectFacetsManager.getFacetedProjects();
            for (IFacetedProject fp : facetedProjects) {
                if (!project.getName().equals(fp.getProject().getName()) || !fp.hasProjectFacet(symfonyFacet)) continue;
                if (fp.hasProjectFacet(symfonyFacet.getVersion("2.1"))) {
                    fp.uninstallProjectFacet(symfonyFacet.getVersion("2.1"), (Object)symfonyFacet, monitor);
                } else if (fp.hasProjectFacet(symfonyFacet.getVersion("2.2"))) {
                    fp.uninstallProjectFacet(symfonyFacet.getVersion("2.2"), (Object)symfonyFacet, monitor);
                }
                break;
            }
        }
        catch (CoreException ex) {
            Logger.logException(ex.getMessage(), ex);
        }
    }
}

