/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.core.goals.evaluator;

import com.dubture.symfony.core.goals.ServiceTypeGoal;
import com.dubture.symfony.core.log.Logger;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.goals.GoalEvaluator;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.typeinference.IModelAccessCache;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.context.IModelCacheContext;
import org.eclipse.php.internal.core.typeinference.goals.phpdoc.PHPDocMethodReturnTypeGoal;

public class ServiceGoalEvaluator
extends GoalEvaluator {
    private static final int STATE_INIT = 0;
    private static final int STATE_GOT_RECEIVER = 2;
    private static final int STATE_WAITING_SERVICE_TYPE = 3;
    private static final int STATE_GOT_SERVICE_TYPE = 4;
    private IEvaluatedType result;
    private int state = 0;
    private String serviceName;

    public ServiceGoalEvaluator(IGoal goal, String serviceName) {
        super(goal);
        this.serviceName = serviceName;
    }

    public IGoal[] init() {
        IGoal goal = this.produceNextSubgoal(null, null, null);
        if (goal != null) {
            return new IGoal[]{goal};
        }
        return IGoal.NO_GOALS;
    }

    private IGoal produceNextSubgoal(IGoal previousGoal, IEvaluatedType previousResult, GoalState goalState) {
        PHPDocMethodReturnTypeGoal typedGoal = (PHPDocMethodReturnTypeGoal)this.goal;
        if (this.state == 0) {
            if (typedGoal.getTypes() == null || typedGoal.getTypes().length < 1) {
                return null;
            }
            this.state = 2;
        }
        if (this.state == 2) {
            this.state = 3;
            IModelAccessCache accessCache = null;
            if (this.goal.getContext() instanceof IModelCacheContext) {
                accessCache = ((IModelCacheContext)this.goal.getContext()).getCache();
            }
            try {
                IType[] types;
                IType[] iTypeArray = types = typedGoal.getTypes();
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    IType[] superClasses;
                    IType type = iTypeArray[n2];
                    String fq = PHPModelUtils.getFullName((IType)type);
                    IGoal result = this.checkName(fq);
                    if (result != null) {
                        return result;
                    }
                    IType[] iTypeArray2 = superClasses = PHPModelUtils.getSuperClasses((IType)type, accessCache != null ? accessCache.getSuperTypeHierarchy(type, null) : null);
                    int n3 = superClasses.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IType sc = iTypeArray2[n4];
                        result = this.checkName(PHPModelUtils.getFullName((IType)sc));
                        if (result != null) {
                            return result;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            catch (ModelException e) {
                Logger.logException(e);
            }
        }
        if (this.state == 3) {
            this.result = previousResult;
            this.state = 4;
        }
        return null;
    }

    private IGoal checkName(String fq) {
        if (fq.equals("Symfony\\Component\\DependencyInjection\\ContainerInterface") || fq.equals("Symfony\\Bundle\\FrameworkBundle\\Controller\\Controller")) {
            return this.generateServiceTypeGoal();
        }
        return null;
    }

    private IGoal generateServiceTypeGoal() {
        this.state = 3;
        return new ServiceTypeGoal(this.goal.getContext(), this.serviceName);
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        IGoal goal = this.produceNextSubgoal(subgoal, (IEvaluatedType)result, state);
        if (goal != null) {
            return new IGoal[]{goal};
        }
        return IGoal.NO_GOALS;
    }

    public Object produceResult() {
        return this.result;
    }
}

