/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.core.index;

import com.dubture.symfony.core.builder.SymfonyNature;
import com.dubture.symfony.core.index.visitor.RegisterNamespaceVisitor;
import com.dubture.symfony.core.index.visitor.TemplateVariableVisitor;
import com.dubture.symfony.core.log.Logger;
import com.dubture.symfony.core.model.Service;
import com.dubture.symfony.core.model.SymfonyModelAccess;
import com.dubture.symfony.core.model.TemplateVariable;
import com.dubture.symfony.core.util.JsonUtils;
import com.dubture.symfony.core.util.text.SymfonyTextSequenceUtilities;
import com.dubture.symfony.index.SymfonyIndexer;
import com.dubture.symfony.index.model.Route;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.CallArgumentsList;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.index2.IIndexingRequestor;
import org.eclipse.php.core.compiler.ast.nodes.ClassDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.core.compiler.ast.nodes.ExpressionStatement;
import org.eclipse.php.core.compiler.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PHPCallExpression;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.core.compiler.ast.nodes.PHPMethodDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.core.compiler.ast.nodes.UseStatement;
import org.eclipse.php.core.compiler.ast.visitor.PHPASTVisitor;
import org.eclipse.php.core.index.PHPIndexingVisitorExtension;
import org.eclipse.wst.sse.core.utils.StringUtils;

public class SymfonyIndexingVisitorExtension
extends PHPIndexingVisitorExtension {
    private ClassDeclaration currentClass;
    private TemplateVariableVisitor controllerIndexer;
    private SymfonyIndexer indexer;
    protected Map<String, UsePart> fLastUseParts = new HashMap<String, UsePart>();
    protected NamespaceDeclaration fLastNamespace;
    private boolean isSymfonyResource;

    public void setSourceModule(ISourceModule module) {
        super.setSourceModule(module);
        try {
            IProject project = this.sourceModule.getScriptProject().getProject();
            this.isSymfonyResource = project.isAccessible() && project.getNature(SymfonyNature.NATURE_ID) != null;
        }
        catch (CoreException e) {
            Logger.logException(e);
            this.isSymfonyResource = false;
        }
    }

    public boolean visit(ASTNode s) throws Exception {
        return this.isSymfonyResource;
    }

    public boolean visit(ModuleDeclaration s) throws Exception {
        if (!this.isSymfonyResource) {
            return false;
        }
        if (this.indexer == null) {
            this.indexer = SymfonyIndexer.getInstance();
        }
        return true;
    }

    public boolean visit(Statement s) throws Exception {
        ExpressionStatement stmt;
        if (!this.isSymfonyResource) {
            return false;
        }
        if (s instanceof ExpressionStatement && (stmt = (ExpressionStatement)s).getExpr() instanceof PHPCallExpression) {
            CallArgumentsList args;
            PHPCallExpression call = (PHPCallExpression)stmt.getExpr();
            if (("registerNamespaces".equals(call.getName()) || "registerNamespaceFallbacks".equals(call.getName())) && call.getReceiver() instanceof VariableReference) {
                if (this.sourceModule.getElementName().equals("bootstrap.php")) {
                    return false;
                }
                RegisterNamespaceVisitor registrar = new RegisterNamespaceVisitor(this.sourceModule);
                registrar.visit(call);
                for (IPath namespace : registrar.getNamespaces()) {
                    IIndexingRequestor.ReferenceInfo info = new IIndexingRequestor.ReferenceInfo(201, 0, 0, namespace.toString(), null, null);
                    this.requestor.addReference(info);
                }
            } else if ("setAlias".equals(call.getName()) && call.getReceiver() instanceof VariableReference && (args = call.getArgs()).getChilds().size() == 2) {
                List nodes = args.getChilds();
                try {
                    Scalar alias = (Scalar)nodes.get(0);
                    Scalar reference = (Scalar)nodes.get(1);
                    if (alias != null && reference != null) {
                        String id = SymfonyTextSequenceUtilities.removeQuotes(alias.getValue());
                        Service _service = SymfonyModelAccess.getDefault().findService(StringUtils.stripQuotes((String)reference.getValue()), this.sourceModule.getScriptProject().getPath());
                        if (_service != null) {
                            this.indexer.addService(id, _service.getClassName(), _service.getPublicString(), _service.getTags(), this.sourceModule.getScriptProject().getPath().toString(), 0);
                            this.indexer.exitServices();
                        }
                    }
                }
                catch (ClassCastException classCastException) {}
            }
        }
        return true;
    }

    public boolean visit(Expression s) throws Exception {
        List args;
        ClassInstanceCreation instance;
        if (!this.isSymfonyResource) {
            return false;
        }
        if (s.getClass() == Block.class) {
            s.traverse((ASTVisitor)new PHPASTVisitor(){

                public boolean visit(UseStatement s) throws Exception {
                    Collection parts = s.getParts();
                    for (UsePart part : parts) {
                        String name = null;
                        if (part.getAlias() != null) {
                            name = part.getAlias().getName();
                        } else {
                            name = part.getFullUseStatementName();
                            int index = name.lastIndexOf(92);
                            if (index >= 0) {
                                name = name.substring(index + 1);
                            }
                        }
                        SymfonyIndexingVisitorExtension.this.fLastUseParts.put(name, part);
                    }
                    return true;
                }
            });
        }
        if (s instanceof ClassInstanceCreation && "AppKernel".equals((instance = (ClassInstanceCreation)s).getClassName().toString()) && (args = instance.getCtorParams().getChilds()).get(0) instanceof Scalar) {
            Scalar environment = (Scalar)args.get(0);
            String value = environment.getValue().replace("\"", "").replace("'", "");
            String path = this.sourceModule.getPath().toString();
            Logger.debugMSG("indexing environment: " + value + " => " + path);
            IIndexingRequestor.ReferenceInfo info = new IIndexingRequestor.ReferenceInfo(401, instance.sourceStart(), instance.sourceEnd() - instance.sourceStart(), value, null, path);
            this.requestor.addReference(info);
        }
        return super.visit(s);
    }

    public boolean visit(TypeDeclaration s) throws Exception {
        if (!this.isSymfonyResource) {
            return false;
        }
        if (this.indexer == null) {
            this.indexer = SymfonyIndexer.getInstance();
        }
        if (s instanceof ClassDeclaration) {
            this.currentClass = (ClassDeclaration)s;
        } else if (s instanceof NamespaceDeclaration) {
            this.fLastNamespace = (NamespaceDeclaration)s;
            this.fLastUseParts.clear();
        }
        return true;
    }

    public boolean endvisit(TypeDeclaration s) throws Exception {
        if (this.controllerIndexer != null) {
            Map<TemplateVariable, String> variables = this.controllerIndexer.getTemplateVariables();
            for (TemplateVariable variable : variables.keySet()) {
                String viewPath = variables.get(variable);
                int start = variable.sourceStart();
                int length = variable.sourceEnd() - variable.sourceStart();
                String name = null;
                if (variable.isReference()) {
                    name = variable.getName();
                    String phpClass = variable.getClassName();
                    String namespace = variable.getNamespace();
                    String method = variable.getMethod().getName();
                    String metadata = JsonUtils.createReference(phpClass, namespace, viewPath, method);
                    if (viewPath.contains(".")) {
                        viewPath = viewPath.substring(0, viewPath.indexOf("."));
                    }
                    Logger.debugMSG("add reference info: " + name + " =>  " + viewPath + " with metadata " + metadata);
                    IIndexingRequestor.ReferenceInfo info = new IIndexingRequestor.ReferenceInfo(402, start, length, name, metadata, viewPath);
                    this.requestor.addReference(info);
                    continue;
                }
                if (variable.isScalar()) {
                    name = variable.getName();
                    String method = variable.getMethod().getName();
                    String metadata = JsonUtils.createScalar(name, viewPath, method);
                    if (viewPath.contains(".")) {
                        viewPath = viewPath.substring(0, viewPath.indexOf("."));
                    }
                    Logger.debugMSG("add scalar info: " + name + " => " + viewPath + " with metadata: " + metadata);
                    IIndexingRequestor.ReferenceInfo info = new IIndexingRequestor.ReferenceInfo(402, start, length, name, metadata, viewPath);
                    this.requestor.addReference(info);
                    continue;
                }
                Logger.debugMSG("Unable to resolve template variable: " + variable.getClass().toString());
            }
            Stack<Route> routes = this.controllerIndexer.getRoutes();
            for (Route route : routes) {
                Logger.debugMSG("indexing route: " + route.toString());
                this.indexer.addRoute(route, this.sourceModule.getScriptProject().getPath());
            }
            this.indexer.exitRoutes();
        } else if (s instanceof NamespaceDeclaration) {
            this.fLastNamespace = null;
            this.fLastUseParts.clear();
        }
        this.currentClass = null;
        this.controllerIndexer = null;
        return true;
    }

    public boolean visit(MethodDeclaration s) throws Exception {
        PHPMethodDeclaration method;
        PHPDocBlock docBlock;
        if (!this.isSymfonyResource) {
            return false;
        }
        if (s instanceof PHPMethodDeclaration && (docBlock = (method = (PHPMethodDeclaration)s).getPHPDoc()) != null) {
            PHPDocTag[] tags;
            PHPDocTag[] pHPDocTagArray = tags = docBlock.getTags();
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                PHPDocTag tag = pHPDocTagArray[n2];
                String value = tag.getValue();
                if (tag.getTypeReferences().size() == 1 && tag.getVariableReference() != null) {
                    VariableReference varName = tag.getVariableReference();
                    SimpleReference varType = (SimpleReference)tag.getTypeReferences().get(0);
                    if (varName.getName().equals("$view") && varType.getName().equals("string")) {
                        length = method.sourceEnd() - method.sourceStart();
                        IIndexingRequestor.ReferenceInfo viewMethod = new IIndexingRequestor.ReferenceInfo(300, method.sourceStart(), length, method.getName(), null, null);
                        this.requestor.addReference(viewMethod);
                    } else if (value.contains("route") || value.contains("url")) {
                        length = method.sourceEnd() - method.sourceStart();
                        IIndexingRequestor.ReferenceInfo routeMethod = new IIndexingRequestor.ReferenceInfo(301, method.sourceStart(), length, method.getName(), null, null);
                        this.requestor.addReference(routeMethod);
                    }
                }
                ++n2;
            }
        }
        return true;
    }

    public boolean endvisit(ModuleDeclaration s) throws Exception {
        this.fLastNamespace = null;
        this.fLastUseParts.clear();
        return super.endvisit(s);
    }
}

