/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.core.index.visitor;

import com.dubture.symfony.core.log.Logger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.core.compiler.ast.nodes.ArrayCreation;
import org.eclipse.php.core.compiler.ast.nodes.ArrayElement;
import org.eclipse.php.core.compiler.ast.nodes.InfixExpression;
import org.eclipse.php.core.compiler.ast.nodes.PHPCallExpression;
import org.eclipse.php.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.core.compiler.ast.visitor.PHPASTVisitor;

public class RegisterNamespaceVisitor
extends PHPASTVisitor {
    private ISourceModule source;
    private IPath path;
    private List<IPath> paths = new ArrayList<IPath>();

    public List<IPath> getNamespaces() {
        return this.paths;
    }

    public RegisterNamespaceVisitor(ISourceModule sourceModule) {
        this.source = sourceModule;
        this.path = this.source.getPath().removeLastSegments(1);
    }

    public boolean visit(PHPCallExpression call) throws Exception {
        List nodes = call.getArgs().getChilds();
        if (nodes.size() == 1 && nodes.get(0) instanceof ArrayCreation) {
            ArrayCreation array = (ArrayCreation)nodes.get(0);
            List args = array.getChilds();
            for (ASTNode node : args) {
                if (node instanceof ArrayCreation) {
                    for (Object subNode : ((ArrayCreation)node).getChilds()) {
                        if (!(subNode instanceof ArrayElement)) continue;
                        this.resolveNamespace((ArrayElement)subNode);
                    }
                    continue;
                }
                if (!(node instanceof ArrayElement)) continue;
                this.resolveNamespace((ArrayElement)node);
            }
        }
        return true;
    }

    private void resolveNamespace(ArrayElement element) {
        if (element.getValue() instanceof InfixExpression) {
            InfixExpression infix = (InfixExpression)element.getValue();
            try {
                if (!(infix.getLeft() instanceof Scalar) || !(infix.getRight() instanceof Scalar)) {
                    return;
                }
                Scalar left = (Scalar)infix.getLeft();
                Scalar right = (Scalar)infix.getRight();
                if ("__DIR__".equals(left.getValue())) {
                    String rightPath = right.getValue().replace("'", "").replace("\"", "").replaceFirst("/", "");
                    this.paths.add(this.path.append(rightPath));
                }
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }
    }
}

