/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.core.index.visitor;

import com.dubture.doctrine.annotation.model.Annotation;
import com.dubture.doctrine.core.AnnotationParserUtil;
import com.dubture.doctrine.core.compiler.IAnnotationModuleDeclaration;
import com.dubture.symfony.core.log.Logger;
import com.dubture.symfony.core.model.Service;
import com.dubture.symfony.core.model.SymfonyModelAccess;
import com.dubture.symfony.core.model.TemplateVariable;
import com.dubture.symfony.core.util.AnnotationUtils;
import com.dubture.symfony.core.util.ModelUtils;
import com.dubture.symfony.core.util.PathUtils;
import com.dubture.symfony.index.model.Route;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.expressions.CallArgumentsList;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.core.compiler.ast.nodes.ArrayCreation;
import org.eclipse.php.core.compiler.ast.nodes.ArrayElement;
import org.eclipse.php.core.compiler.ast.nodes.Assignment;
import org.eclipse.php.core.compiler.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.core.compiler.ast.nodes.FormalParameter;
import org.eclipse.php.core.compiler.ast.nodes.FullyQualifiedReference;
import org.eclipse.php.core.compiler.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PHPCallExpression;
import org.eclipse.php.core.compiler.ast.nodes.PHPMethodDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.ReturnStatement;
import org.eclipse.php.core.compiler.ast.nodes.Scalar;
import org.eclipse.php.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.core.compiler.ast.nodes.UseStatement;
import org.eclipse.php.core.compiler.ast.visitor.PHPASTVisitor;
import org.eclipse.php.internal.core.model.PerFileModelAccessCache;
import org.eclipse.php.internal.core.typeinference.IModelAccessCache;
import org.eclipse.wst.sse.core.utils.StringUtils;

public class TemplateVariableVisitor
extends PHPASTVisitor {
    private Map<TemplateVariable, String> templateVariables = new HashMap<TemplateVariable, String>();
    private Stack<TemplateVariable> deferredVariables = new Stack();
    private PHPMethodDeclaration currentMethod;
    private final List<UseStatement> useStatements;
    private final NamespaceDeclaration namespace;
    private boolean inAction = false;
    private String currentAnnotationPath;
    private Stack<Route> routes = new Stack();
    private final String bundle;
    private String controller;
    private ISourceModule source;
    private IModelAccessCache cache;
    private IAnnotationModuleDeclaration annotationModule;

    public TemplateVariableVisitor(List<UseStatement> useStatements, NamespaceDeclaration namespace, ISourceModule source) {
        this.namespace = namespace;
        this.useStatements = useStatements;
        this.source = source;
        try {
            this.annotationModule = AnnotationParserUtil.getModule((ISourceModule)source);
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        this.cache = new PerFileModelAccessCache(source);
        this.bundle = ModelUtils.extractBundleName(namespace);
    }

    public Map<TemplateVariable, String> getTemplateVariables() {
        return this.templateVariables;
    }

    public boolean visit(PHPMethodDeclaration methodDeclaration) throws Exception {
        this.currentMethod = methodDeclaration;
        this.deferredVariables = new Stack();
        this.controller = this.currentMethod.getDeclaringTypeName().replace("Controller", "");
        this.inAction = methodDeclaration.getName().endsWith("Action");
        if (!this.inAction) {
            return false;
        }
        String action = this.currentMethod.getName().replace("Action", "");
        if (this.annotationModule != null) {
            List annotations = this.annotationModule.readAnnotations((ASTNode)methodDeclaration).getAnnotations();
            for (Annotation annotation : annotations) {
                String className = annotation.getClassName();
                if (className.startsWith("Template")) {
                    this.currentAnnotationPath = AnnotationUtils.extractTemplate(annotation, this.bundle, this.controller, action);
                    continue;
                }
                if (!className.startsWith("Route")) continue;
                Route route = AnnotationUtils.extractRoute(annotation, this.bundle, this.controller, action);
                this.routes.push(route);
            }
        }
        for (Object argument : this.currentMethod.getArguments()) {
            if (!(argument instanceof FormalParameter)) continue;
            FormalParameter param = (FormalParameter)argument;
            if (param.getParameterType() instanceof FullyQualifiedReference) {
                FullyQualifiedReference ref = (FullyQualifiedReference)param.getParameterType();
                NamespaceReference nsRef = this.createFromFQCN(ref);
                if (nsRef == null) continue;
                TemplateVariable tempVar = new TemplateVariable(this.currentMethod, param.getName(), param.sourceStart(), param.sourceEnd(), nsRef.namespace, nsRef.className);
                this.deferredVariables.push(tempVar);
                continue;
            }
            TemplateVariable tempVar = new TemplateVariable(this.currentMethod, param.getName(), param.sourceStart(), param.sourceEnd(), null, null);
            this.deferredVariables.push(tempVar);
        }
        return true;
    }

    public boolean endvisit(PHPMethodDeclaration s) throws Exception {
        this.currentAnnotationPath = null;
        this.deferredVariables = null;
        this.currentMethod = null;
        this.inAction = false;
        return true;
    }

    public boolean endvisit(PHPCallExpression s) throws Exception {
        if (!s.getName().startsWith("render")) {
            return false;
        }
        CallArgumentsList list = s.getArgs();
        if (list.getChilds().size() > 1 && list.getChilds().get(0) instanceof Scalar && list.getChilds().get(1) instanceof ArrayCreation) {
            Scalar scalar = (Scalar)list.getChilds().get(0);
            String viewPath = StringUtils.stripQuotes((String)scalar.getValue());
            ArrayCreation params = (ArrayCreation)list.getChilds().get(1);
            this.parseVariablesFromArray(params, viewPath);
        }
        return true;
    }

    public boolean visit(PHPCallExpression s) throws Exception {
        return true;
    }

    public boolean visit(ReturnStatement statement) throws Exception {
        if (this.inAction) {
            PHPCallExpression expression;
            String callName;
            if (statement.getExpr().getClass() == ArrayCreation.class) {
                if (this.namespace != null) {
                    String viewPath = null;
                    if (this.currentAnnotationPath != null) {
                        viewPath = this.currentAnnotationPath;
                    } else {
                        String template = this.currentMethod.getName().replace("Action", "");
                        viewPath = String.format("%s:%s:%s", this.bundle, this.controller, template);
                    }
                    if (viewPath != null) {
                        ArrayCreation array = (ArrayCreation)statement.getExpr();
                        this.parseVariablesFromArray(array, viewPath);
                    }
                }
            } else if (statement.getExpr().getClass() == PHPCallExpression.class && (callName = (expression = (PHPCallExpression)statement.getExpr()).getCallName().getName()).startsWith("render")) {
                CallArgumentsList args = expression.getArgs();
                List children = args.getChilds();
                Scalar view = (Scalar)children.get(0);
                if (children.size() >= 2 && ((ASTNode)children.get(1)).getClass() == ArrayCreation.class) {
                    this.parseVariablesFromArray((ArrayCreation)children.get(1), PathUtils.createViewPath(view));
                } else {
                    Logger.log(2, "Unable to parse view variable from " + children.toString());
                }
            }
        }
        return true;
    }

    private void parseVariablesFromArray(ArrayCreation array, String viewPath) {
        block2: for (ArrayElement element : array.getElements()) {
            Expression key = element.getKey();
            Expression value = element.getValue();
            if (key.getClass() != Scalar.class) continue;
            Scalar varName = (Scalar)key;
            if (value.getClass() == VariableReference.class) {
                VariableReference ref = (VariableReference)value;
                for (TemplateVariable variable : this.deferredVariables) {
                    if (!ref.getName().equals(variable.getName())) continue;
                    variable.setName(varName.getValue());
                    this.templateVariables.put(variable, viewPath);
                    continue block2;
                }
                continue;
            }
            if (value.getClass() == PHPCallExpression.class) {
                PHPCallExpression callExp = (PHPCallExpression)value;
                VariableReference varRef = null;
                try {
                    varRef = (VariableReference)callExp.getReceiver();
                }
                catch (ClassCastException classCastException) {
                    Logger.log(2, String.valueOf(callExp.getReceiver().getClass().toString()) + " could not be cast to VariableReference in " + this.currentMethod.getName());
                }
                if (varRef == null) continue;
                SimpleReference callName = callExp.getCallName();
                for (TemplateVariable deferred : this.deferredVariables) {
                    if (!deferred.getName().equals(varRef.getName())) continue;
                    TemplateVariable tempVar = SymfonyModelAccess.getDefault().createTemplateVariableByReturnType(this.source, this.currentMethod, callName, deferred.getClassName(), deferred.getNamespace(), varRef.getName(), this.cache);
                    this.templateVariables.put(tempVar, viewPath);
                    continue block2;
                }
                continue;
            }
            if (value.getClass() == ClassInstanceCreation.class) {
                FullyQualifiedReference fqcn;
                NamespaceReference nsRef;
                ClassInstanceCreation instance = (ClassInstanceCreation)value;
                if (instance.getClassName().getClass() != FullyQualifiedReference.class || (nsRef = this.createFromFQCN(fqcn = (FullyQualifiedReference)instance.getClassName())) == null) continue;
                TemplateVariable variable = new TemplateVariable(this.currentMethod, varName.getValue(), varName.sourceStart(), varName.sourceEnd(), nsRef.getNamespace(), nsRef.getClassName());
                this.templateVariables.put(variable, viewPath);
                continue;
            }
            Logger.debugMSG("array value: " + value.getClass());
        }
    }

    public boolean visit(Assignment s) throws Exception {
        if (this.inAction) {
            Service service = null;
            if (s.getVariable().getClass() == VariableReference.class) {
                VariableReference var = (VariableReference)s.getVariable();
                if (s.getValue().getClass() == PHPCallExpression.class) {
                    PHPCallExpression exp = (PHPCallExpression)s.getValue();
                    if (exp.getName().equals("get")) {
                        service = ModelUtils.extractServiceFromCall(exp, this.source.getScriptProject().getPath());
                        if (service != null) {
                            String fqsn = service.getNamespace() != null ? service.getNamespace().getQualifiedName() : null;
                            TemplateVariable tempVar = new TemplateVariable(this.currentMethod, var.getName(), exp.sourceStart(), exp.sourceEnd(), fqsn, service.getClassName());
                            this.deferredVariables.push(tempVar);
                        }
                    } else if (exp.getReceiver().getClass() == PHPCallExpression.class) {
                        service = ModelUtils.extractServiceFromCall((PHPCallExpression)exp.getReceiver(), this.source.getScriptProject().getPath());
                        if (service == null || exp.getCallName() == null) {
                            return true;
                        }
                        SimpleReference callName = exp.getCallName();
                        String fqsn = service.getNamespace() != null ? service.getNamespace().getQualifiedName() : null;
                        TemplateVariable tempVar = null;
                        tempVar = SymfonyModelAccess.getDefault().createTemplateVariableByReturnType(this.source, this.currentMethod, callName, service.getClassName(), fqsn, var.getName(), this.cache);
                        if (tempVar != null) {
                            this.deferredVariables.push(tempVar);
                        }
                    } else if (exp.getReceiver().getClass() == VariableReference.class) {
                        VariableReference varRef = (VariableReference)exp.getReceiver();
                        SimpleReference ref = exp.getCallName();
                        for (TemplateVariable tempVar : this.deferredVariables) {
                            TemplateVariable tVar;
                            if (!tempVar.getName().equals(varRef.getName()) || (tVar = SymfonyModelAccess.getDefault().createTemplateVariableByReturnType(this.source, this.currentMethod, ref, tempVar.getClassName(), tempVar.getNamespace(), var.getName(), this.cache)) == null) continue;
                            this.deferredVariables.push(tVar);
                            break;
                        }
                    }
                } else if (s.getValue().getClass() == ClassInstanceCreation.class) {
                    FullyQualifiedReference fqcn;
                    NamespaceReference nsRef;
                    ClassInstanceCreation instance = (ClassInstanceCreation)s.getValue();
                    if (instance.getClassName().getClass() == FullyQualifiedReference.class && (nsRef = this.createFromFQCN(fqcn = (FullyQualifiedReference)instance.getClassName())) != null) {
                        TemplateVariable variable = new TemplateVariable(this.currentMethod, var.getName(), var.sourceStart(), var.sourceEnd(), nsRef.getNamespace(), nsRef.getClassName());
                        this.deferredVariables.push(variable);
                    }
                } else if (s.getValue().getClass() == Scalar.class) {
                    TemplateVariable variable = new TemplateVariable(this.currentMethod, var.getName(), var.sourceStart(), var.sourceEnd(), null, null);
                    this.deferredVariables.push(variable);
                }
            }
        }
        return true;
    }

    private NamespaceReference createFromFQCN(FullyQualifiedReference fqcn) {
        for (UseStatement use : this.useStatements) {
            for (UsePart part : use.getParts()) {
                if (!part.getNamespace().getName().equals(fqcn.getName())) continue;
                String name = fqcn.getName();
                String qualifier = part.getNamespace().getNamespace().getName();
                return new NamespaceReference(qualifier, name);
            }
        }
        return null;
    }

    public Stack<Route> getRoutes() {
        return this.routes;
    }

    private class NamespaceReference {
        private String namespace;
        private String className;

        public NamespaceReference(String qualifier, String name) {
            this.namespace = qualifier;
            this.className = name;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getClassName() {
            return this.className;
        }
    }
}

