/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.symfony.core.model;

import com.dubture.symfony.core.index.SymfonyElementResolver;
import com.dubture.symfony.core.log.Logger;
import com.dubture.symfony.core.model.Bundle;
import com.dubture.symfony.core.model.EntityAlias;
import com.dubture.symfony.core.model.Service;
import com.dubture.symfony.core.model.TemplateVariable;
import com.dubture.symfony.core.model.Translation;
import com.dubture.symfony.core.model.ViewPath;
import com.dubture.symfony.core.util.JsonUtils;
import com.dubture.symfony.core.util.ModelUtils;
import com.dubture.symfony.core.util.PathUtils;
import com.dubture.symfony.index.SymfonyIndexer;
import com.dubture.symfony.index.handler.IServiceHandler;
import com.dubture.symfony.index.handler.ITranslationHandler;
import com.dubture.symfony.index.model.Parameter;
import com.dubture.symfony.index.model.Route;
import com.dubture.symfony.index.model.TransUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.INamespace;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.index2.IElementResolver;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.index2.search.ISearchRequestor;
import org.eclipse.dltk.core.index2.search.ModelAccess;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.dltk.internal.core.ScriptFolder;
import org.eclipse.dltk.internal.core.util.LRUCache;
import org.eclipse.php.core.compiler.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.core.compiler.ast.nodes.PHPMethodDeclaration;
import org.eclipse.php.core.compiler.ast.visitor.PHPASTVisitor;
import org.eclipse.php.internal.core.PHPLanguageToolkit;
import org.eclipse.php.internal.core.model.PHPModelAccess;
import org.eclipse.php.internal.core.typeinference.IModelAccessCache;

public class SymfonyModelAccess
extends PHPModelAccess {
    private static SymfonyModelAccess modelInstance = null;
    private SymfonyIndexer index;
    private Map<Service, IType[]> serviceCache = new HashMap<Service, IType[]>();
    private LRUCache controllerCache = new LRUCache();
    private LRUCache serviceCache2 = new LRUCache();
    private LRUCache entityCache = new LRUCache();
    private LRUCache bundleCache = new LRUCache();
    private static final String NULL_ENTRY = "$$THIS_IS_NULL_ENTRY$$";

    private SymfonyModelAccess() {
        try {
            this.index = SymfonyIndexer.getInstance();
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    public static SymfonyModelAccess getDefault() {
        if (modelInstance == null) {
            modelInstance = new SymfonyModelAccess();
        }
        return modelInstance;
    }

    public TemplateVariable createTemplateVariableByReturnType(ISourceModule sourceModule, PHPMethodDeclaration controllerMethod, SimpleReference callName, String className, String namespace, String variableName) {
        return this.createTemplateVariableByReturnType(sourceModule, controllerMethod, callName, className, namespace, variableName, null);
    }

    public TemplateVariable createTemplateVariableByReturnType(ISourceModule sourceModule, PHPMethodDeclaration controllerMethod, SimpleReference callName, String className, String namespace, String variableName, IModelAccessCache cache) {
        IType[] types = null;
        if (cache != null) {
            Collection typesList = cache.getTypes(sourceModule, className, namespace, null);
            types = typesList.toArray(new IType[typesList.size()]);
        } else {
            IDLTKSearchScope scope = this.createSearchScope(sourceModule);
            if (scope == null) {
                return null;
            }
            types = this.findTypes(namespace, className, ISearchEngine.MatchRule.EXACT, 0, 0, scope, null);
        }
        if (types.length != 1) {
            return null;
        }
        IType type = types[0];
        IMethod method = type.getMethod(callName.getName());
        if (method == null) {
            return null;
        }
        ModuleDeclaration module = SourceParserUtil.getModuleDeclaration((ISourceModule)method.getSourceModule());
        ReturnTypeVisitor visitor = new ReturnTypeVisitor(method.getElementName());
        try {
            module.traverse((ASTVisitor)visitor);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        if (visitor.className == null || visitor.namespace == null) {
            return null;
        }
        return new TemplateVariable(controllerMethod, variableName, callName.sourceStart(), callName.sourceEnd(), visitor.namespace, visitor.className);
    }

    protected IDLTKSearchScope createSearchScope(ISourceModule module) {
        IScriptProject scriptProject = module.getScriptProject();
        if (scriptProject != null) {
            return SearchEngine.createSearchScope((IModelElement)scriptProject);
        }
        return null;
    }

    public List<SymfonyElementResolver.TemplateField> findTemplateVariables(IType controller) {
        if (controller == null) {
            return new ArrayList<SymfonyElementResolver.TemplateField>();
        }
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)controller.getScriptProject());
        ISearchEngine engine = ModelAccess.getSearchEngine((IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
        final ArrayList<SymfonyElementResolver.TemplateField> variables = new ArrayList<SymfonyElementResolver.TemplateField>();
        if (scope == null || engine == null) {
            return variables;
        }
        final IElementResolver resolver = ModelAccess.getElementResolver((IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
        engine.search(402, null, null, 0, 0, 100, ISearchEngine.SearchFor.REFERENCES, ISearchEngine.MatchRule.PREFIX, scope, new ISearchRequestor(){

            public void match(int elementType, int flags, int offset, int length, int nameOffset, int nameLength, String elementName, String metadata, String doc, String qualifier, String parent, ISourceModule sourceModule, boolean isReference) {
                IModelElement element = resolver.resolve(elementType, flags, offset, length, nameOffset, nameLength, elementName, metadata, doc, qualifier, parent, sourceModule);
                if (element != null && element instanceof SymfonyElementResolver.TemplateField) {
                    variables.add((SymfonyElementResolver.TemplateField)element);
                }
            }
        }, null);
        return variables;
    }

    public IType findControllerByTemplate(ISourceModule module) {
        String controller = PathUtils.getControllerFromTemplatePath(module.getPath());
        if (controller == null) {
            return null;
        }
        IType[] types = PHPModelAccess.getDefault().findTypes(controller, ISearchEngine.MatchRule.EXACT, 0, 0, SearchEngine.createSearchScope((IModelElement)module.getScriptProject()), null);
        if (types.length != 1) {
            return null;
        }
        return types[0];
    }

    public SymfonyElementResolver.TemplateField findTemplateVariableType(String variableName, ISourceModule sourceModule) {
        IType controller = this.findControllerByTemplate(sourceModule);
        if (controller == null) {
            return null;
        }
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)controller);
        ISearchEngine engine = ModelAccess.getSearchEngine((IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
        if (scope == null || engine == null) {
            return null;
        }
        final ArrayList variables = new ArrayList();
        final IElementResolver resolver = ModelAccess.getElementResolver((IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
        engine.search(402, null, variableName, 0, 0, 100, ISearchEngine.SearchFor.REFERENCES, ISearchEngine.MatchRule.EXACT, scope, new ISearchRequestor(){

            public void match(int elementType, int flags, int offset, int length, int nameOffset, int nameLength, String elementName, String metadata, String doc, String qualifier, String parent, ISourceModule sourceModule, boolean isReference) {
                IModelElement element = resolver.resolve(elementType, flags, offset, length, nameOffset, nameLength, elementName, metadata, doc, qualifier, parent, sourceModule);
                if (element != null && element instanceof SymfonyElementResolver.TemplateField) {
                    variables.add((SymfonyElementResolver.TemplateField)element);
                }
            }
        }, null);
        if (variables.size() > 0) {
            return (SymfonyElementResolver.TemplateField)((Object)variables.get(0));
        }
        return null;
    }

    public List<Parameter> findParameters(IScriptProject project) {
        return this.index.findParameters(project.getPath());
    }

    public List<Route> findRoutes(IScriptProject project) {
        if (this.index == null) {
            Logger.log(4, "The SymfonyIndexer has not been instantiated...");
            return new ArrayList<Route>();
        }
        return this.index.findRoutes(project.getPath());
    }

    public List<Route> findRoutes(IScriptProject project, String prefix) {
        if (this.index == null) {
            Logger.log(4, "The SymfonyIndexer has not been instantiated...");
            return new ArrayList<Route>();
        }
        return this.index.findRoutes(project.getPath(), prefix);
    }

    public List<Bundle> findBundles(IScriptProject project) {
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)project.getScriptProject());
        ISearchEngine engine = ModelAccess.getSearchEngine((IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
        final ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        if (scope == null || engine == null) {
            return bundles;
        }
        engine.search(200, null, null, 0, 0, 100, ISearchEngine.SearchFor.REFERENCES, ISearchEngine.MatchRule.PREFIX, scope, new ISearchRequestor(){

            public void match(int elementType, int flags, int offset, int length, int nameOffset, int nameLength, String elementName, String metadata, String doc, String qualifier, String parent, ISourceModule sourceModule, boolean isReference) {
                bundles.add(JsonUtils.unpackBundle(metadata));
            }
        }, null);
        return bundles;
    }

    public ScriptFolder findBundleFolder(String bundle, IScriptProject project) {
        IType bundleType = this.findBundleType(bundle, project);
        return (ScriptFolder)bundleType.getSourceModule().getParent();
    }

    public IType findBundleType(String bundle, IScriptProject project) {
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)project);
        IType[] types = this.findTypes(bundle, ISearchEngine.MatchRule.EXACT, 0, 0, scope, null);
        if (types.length != 1) {
            return null;
        }
        return types[0];
    }

    public IType[] findBundleControllers(String bundle, IScriptProject project) {
        ScriptFolder bundleFolder = this.findBundleFolder(bundle, project);
        if (bundleFolder == null) {
            return null;
        }
        ISourceModule controllerSource = bundleFolder.getSourceModule("Controller");
        if (controllerSource == null) {
            return null;
        }
        IDLTKSearchScope controllerScope = SearchEngine.createSearchScope((IModelElement)controllerSource);
        return this.findTypes("", ISearchEngine.MatchRule.PREFIX, 0, 0, controllerScope, null);
    }

    public List<IPath> findBundleViewPaths(String bundle, IScriptProject project) {
        ScriptFolder folder = this.findBundleFolder(bundle, project);
        LinkedList<IPath> viewPaths = new LinkedList<IPath>();
        if (folder == null) {
            return viewPaths;
        }
        try {
            IResource resource = folder.getUnderlyingResource();
            LinkedList<IPath> structure = new LinkedList<IPath>();
            IPath path = resource.getFullPath();
            path = path.removeFirstSegments(1).append("Resources").append("views");
            int num = path.segmentCount() + 1;
            IFolder viewFolder = project.getProject().getFolder(path);
            this.getFolderStructure(viewFolder, structure);
            for (IPath p : structure) {
                viewPaths.add(p.removeFirstSegments(num));
            }
        }
        catch (ModelException e) {
            Logger.logException(e);
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        return viewPaths;
    }

    protected List<IPath> getFolderStructure(IFolder folder, List<IPath> structure) throws CoreException {
        IResource[] iResourceArray = folder.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource child = iResourceArray[n2];
            if (child instanceof IFolder) {
                structure.add(child.getFullPath());
                this.getFolderStructure((IFolder)child, structure);
            }
            ++n2;
        }
        return structure;
    }

    public IModelElement[] findTemplates(String bundle, String controller, IScriptProject project) {
        try {
            ScriptFolder bundleFolder = this.findBundleFolder(bundle, project);
            Path relative = new Path("Resources/views/" + controller.replace("Controller", ""));
            IPath path = bundleFolder.getPath().append((IPath)relative);
            IScriptFolder sfolder = project.findScriptFolder(path);
            if (sfolder != null && sfolder.exists() && sfolder.hasChildren()) {
                return sfolder.getChildren();
            }
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return new IModelElement[0];
    }

    public boolean hasViewMethod(String method, IScriptProject project) {
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)project);
        ISearchEngine engine = SymfonyModelAccess.getSearchEngine((IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
        if (scope == null || engine == null) {
            return false;
        }
        final ArrayList methods = new ArrayList();
        engine.search(300, null, method, 0, 0, 10, ISearchEngine.SearchFor.REFERENCES, ISearchEngine.MatchRule.EXACT, scope, new ISearchRequestor(){

            public void match(int elementType, int flags, int offset, int length, int nameOffset, int nameLength, String elementName, String metadata, String doc, String qualifier, String parent, ISourceModule sourceModule, boolean isReference) {
                methods.add(elementName);
            }
        }, null);
        return methods.size() > 0;
    }

    public IType[] findServiceTypes(Service service, IScriptProject project) {
        if (this.serviceCache.containsKey((Object)service)) {
            return this.serviceCache.get((Object)service);
        }
        try {
            IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)project);
            String namespace = service.getNamespace() != null ? service.getNamespace().getQualifiedName() : null;
            IType[] types = this.findTypes(namespace, service.getClassName(), ISearchEngine.MatchRule.EXACT, 0, 0, scope, null);
            this.serviceCache.put(service, types);
            return types;
        }
        catch (Exception e) {
            Logger.logException(e);
            if (service != null) {
                Logger.debugMSG("No types found for service: " + service.getId());
            } else {
                Logger.debugMSG("Cannot find service type, service is null");
            }
            return new IType[0];
        }
    }

    public IType findServiceType(Service service, IScriptProject project) {
        IType[] types = this.findServiceTypes(service, project);
        if (types.length > 0) {
            return types[0];
        }
        return null;
    }

    public Service findService(String id, IPath path) {
        if (path == null) {
            Logger.debugMSG("cannot find service without path: " + id);
            return null;
        }
        String key = String.valueOf(id) + path.toString();
        if (this.serviceCache2.get((Object)key) != null) {
            return this.serviceCache2.get((Object)key) == NULL_ENTRY ? null : (Service)((Object)this.serviceCache2.get((Object)key));
        }
        final ArrayList services = new ArrayList();
        if (this.index == null) {
            Logger.log(4, "The SymfonyIndexer has not been instantiated...");
            return null;
        }
        String pathString = path == null ? "" : path.toString();
        this.index.findService(id, pathString, new IServiceHandler(){

            public void handle(String id, String phpClass, String path, String _public, String tags) {
                Service s = new Service(id, phpClass, path, null);
                s.setTags(tags);
                s.setPublic(_public);
                services.add(s);
            }
        });
        if (services.size() == 1) {
            Service service = (Service)((Object)services.get(0));
            String fqcn = service.getFullyQualifiedName();
            if (fqcn.startsWith("alias_")) {
                String alias = fqcn.substring(fqcn.indexOf("_") + 1);
                Service reference = SymfonyModelAccess.getDefault().findService(alias, service.getPath());
                if (reference != null) {
                    this.serviceCache2.put((Object)key, (Object)reference);
                    return reference;
                }
            }
            this.serviceCache2.put((Object)key, (Object)service);
            return service;
        }
        this.serviceCache2.put((Object)key, (Object)NULL_ENTRY);
        return null;
    }

    public List<Service> findServices(IPath path) {
        final ArrayList<Service> services = new ArrayList<Service>();
        if (this.index == null) {
            Logger.log(4, "The SymfonyIndexer has not been instantiated...");
            return null;
        }
        this.index.findServices(path.toString(), new IServiceHandler(){

            public void handle(String id, String phpClass, String path, String _public, String tags) {
                Service s = new Service(id, phpClass, path);
                s.setTags(tags);
                s.setPublic(_public);
                if (!services.contains((Object)s)) {
                    services.add(s);
                }
            }
        });
        return services;
    }

    public List<String> findServiceTags(IPath path) {
        try {
            return this.index.findTags(path);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean hasRouteMethod(String method, IScriptProject project) {
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)project);
        ISearchEngine engine = SymfonyModelAccess.getSearchEngine((IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
        if (scope == null || engine == null) {
            return false;
        }
        final ArrayList methods = new ArrayList();
        engine.search(301, null, method, 0, 0, 10, ISearchEngine.SearchFor.REFERENCES, ISearchEngine.MatchRule.EXACT, scope, new ISearchRequestor(){

            public void match(int elementType, int flags, int offset, int length, int nameOffset, int nameLength, String elementName, String metadata, String doc, String qualifier, String parent, ISourceModule sourceModule, boolean isReference) {
                methods.add(elementName);
            }
        }, null);
        return methods.size() > 0;
    }

    public Route findRoute(String route, IScriptProject scriptProject) {
        if (this.index == null) {
            Logger.log(4, "The SymfonyIndexer has not been instantiated...");
            return null;
        }
        return this.index.findRoute(route, scriptProject.getPath());
    }

    public IType findController(String bundle, String controller, IScriptProject scriptProject) {
        IType[] controllers;
        ScriptFolder bundleFolder;
        String name = scriptProject.getElementName();
        String key = String.valueOf(bundle) + controller + name;
        if (this.controllerCache.get((Object)key) != null) {
            return this.controllerCache.get((Object)key) == NULL_ENTRY ? null : (IType)this.controllerCache.get((Object)key);
        }
        IType findBundleType = this.findBundleType(bundle, scriptProject);
        if (findBundleType == null) {
            return null;
        }
        IModelElement parent = findBundleType.getParent();
        StringBuilder ns = new StringBuilder();
        if (parent.getElementType() == 7) {
            ns.append(parent.getElementName());
        }
        if ((bundleFolder = (ScriptFolder)parent.getAncestor(IScriptFolder.class)) == null) {
            return null;
        }
        ISourceModule controllerSource = bundleFolder.getSourceModule("Controller");
        if (controllerSource == null) {
            return null;
        }
        IDLTKSearchScope controllerScope = SearchEngine.createSearchScope((IModelElement)controllerSource);
        String[] split = controller.split("/");
        ns.append("\\Controller");
        if (split.length > 1) {
            int i = 0;
            while (i + 1 < split.length) {
                ns.append('\\').append(split[i]);
                ++i;
            }
            controller = split[split.length - 1];
        }
        if ((controllers = this.findTypes(ns.toString(), String.valueOf(controller) + "Controller", ISearchEngine.MatchRule.PREFIX, 0, 0, controllerScope, null)).length == 1) {
            this.controllerCache.put((Object)key, (Object)controllers[0]);
            return controllers[0];
        }
        this.controllerCache.put((Object)key, (Object)NULL_ENTRY);
        return null;
    }

    public IModelElement[] findRootTemplates(IScriptProject scriptProject) {
        try {
            IPath path = scriptProject.getPath().append((IPath)new Path("app/Resources/views"));
            IScriptFolder sfolder = scriptProject.findScriptFolder(path);
            if (sfolder != null && sfolder.exists() && sfolder.hasChildren()) {
                return sfolder.getChildren();
            }
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return new IModelElement[0];
    }

    public IModelElement[] findBundleRootTemplates(String bundle, IScriptProject project) {
        try {
            ScriptFolder bundleFolder = this.findBundleFolder(bundle, project);
            Path path = new Path("Resources/views/");
            IPath viewPath = bundleFolder.getPath().append((IPath)path);
            IScriptFolder sfolder = project.findScriptFolder(viewPath);
            if (sfolder != null && sfolder.exists() && sfolder.hasChildren()) {
                return sfolder.getChildren();
            }
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return new IModelElement[0];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IModelElement findTemplate(ViewPath viewPath, IScriptProject project) {
        try {
            String bundle = viewPath.getBundle();
            String controller = viewPath.getController();
            String template = viewPath.getTemplate();
            if (viewPath.isRoot()) {
                IPath path = project.getPath().append((IPath)new Path("app/Resources/views"));
                IScriptFolder sfolder = project.findScriptFolder(path);
                if (sfolder == null) return null;
                return sfolder.getSourceModule(template);
            }
            if (viewPath.isBundleBasePath()) {
                ScriptFolder bundleFolder = this.findBundleFolder(bundle, project);
                if (bundleFolder == null) {
                    return null;
                }
                IScriptFolder viewFolder = project.findScriptFolder(bundleFolder.getPath().append((IPath)new Path("Resources/views")));
                if (viewFolder == null) return null;
                return viewFolder.getSourceModule(template);
            }
            if (bundle == null) return null;
            if (controller == null) {
                return null;
            }
            ScriptFolder bundleFolder = this.findBundleFolder(bundle, project);
            Path path = new Path("Resources/views/" + controller.replace("Controller", ""));
            IPath iPath = bundleFolder.getPath().append((IPath)path);
            IScriptFolder sfolder = project.findScriptFolder(iPath);
            if (sfolder == null) return null;
            return sfolder.getSourceModule(template);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return null;
    }

    public IMethod findAction(Route route, IScriptProject project) {
        ViewPath vPath = new ViewPath(route.getViewPath());
        if (!vPath.isValid()) {
            return null;
        }
        IType type = null;
        IType[] controllers = this.findBundleControllers(vPath.getBundle(), project);
        if (controllers == null) {
            String msg = "Unable to find bundle controllers ";
            if (vPath != null) {
                msg = String.valueOf(msg) + vPath.getBundle();
            }
            if (project != null) {
                msg = String.valueOf(msg) + " project: " + project.getElementName();
            }
            Logger.debugMSG(msg);
            return null;
        }
        String ctrl = String.valueOf(vPath.getController()) + "Controller";
        IType[] iTypeArray = controllers;
        int n = controllers.length;
        int n2 = 0;
        while (n2 < n) {
            IType t = iTypeArray[n2];
            if (t.getElementName().equals(ctrl)) {
                type = t;
                break;
            }
            ++n2;
        }
        if (type == null) {
            return null;
        }
        IMethod method = type.getMethod(String.valueOf(vPath.getTemplate()) + "Action");
        if (method != null) {
            return method;
        }
        return type.getMethod(vPath.getTemplate());
    }

    public String findNameSpace(IScriptProject iScriptProject, final IPath path) {
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)iScriptProject);
        ISearchEngine engine = ModelAccess.getSearchEngine((IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
        if (scope == null || engine == null) {
            return null;
        }
        final ArrayList namespaces = new ArrayList();
        engine.search(201, null, null, 0, 0, 100, ISearchEngine.SearchFor.REFERENCES, ISearchEngine.MatchRule.PREFIX, scope, new ISearchRequestor(){

            public void match(int elementType, int flags, int offset, int length, int nameOffset, int nameLength, String elementName, String metadata, String doc, String qualifier, String parent, ISourceModule sourceModule, boolean isReference) {
                if (path != null && path.toString().startsWith(elementName)) {
                    namespaces.add(path.toString().replace(elementName, ""));
                }
            }
        }, null);
        if (namespaces.size() > 0) {
            String namespace = (String)namespaces.get(0);
            if (namespace.startsWith("/")) {
                namespace = namespace.replaceFirst("/", "");
            }
            return namespace.replace("/", "\\");
        }
        return null;
    }

    public List<String> getNameSpaces(IScriptProject project) {
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)project);
        ISearchEngine engine = ModelAccess.getSearchEngine((IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
        final ArrayList<String> namespaces = new ArrayList<String>();
        if (scope == null || engine == null) {
            return namespaces;
        }
        engine.search(201, null, null, 0, 0, 100, ISearchEngine.SearchFor.REFERENCES, ISearchEngine.MatchRule.PREFIX, scope, new ISearchRequestor(){

            public void match(int elementType, int flags, int offset, int length, int nameOffset, int nameLength, String elementName, String metadata, String doc, String qualifier, String parent, ISourceModule sourceModule, boolean isReference) {
                namespaces.add(elementName);
            }
        }, null);
        return namespaces;
    }

    public IPath resolveBundleShortcut(String string, IScriptProject project) {
        String bundle = string.replace("@", "");
        ScriptFolder folder = this.findBundleFolder(bundle, project);
        if (folder != null) {
            return folder.getPath();
        }
        return null;
    }

    public Bundle findBundle(String bundleAlias, IScriptProject scriptProject) {
        String key = String.valueOf(bundleAlias) + scriptProject.getElementName();
        if (this.bundleCache.get((Object)key) != null) {
            return this.bundleCache.get((Object)key) == NULL_ENTRY ? null : (Bundle)((Object)this.bundleCache.get((Object)key));
        }
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
        ISearchEngine engine = ModelAccess.getSearchEngine((IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
        if (scope == null || engine == null) {
            return null;
        }
        final ArrayList bundles = new ArrayList();
        engine.search(200, null, bundleAlias, 0, 0, 100, ISearchEngine.SearchFor.REFERENCES, ISearchEngine.MatchRule.EXACT, scope, new ISearchRequestor(){

            public void match(int elementType, int flags, int offset, int length, int nameOffset, int nameLength, String elementName, String metadata, String doc, String qualifier, String parent, ISourceModule sourceModule, boolean isReference) {
                bundles.add(JsonUtils.unpackBundle(metadata));
            }
        }, null);
        if (bundles.size() == 1) {
            Bundle b = (Bundle)((Object)bundles.get(0));
            this.bundleCache.put((Object)key, (Object)b);
            return b;
        }
        this.bundleCache.put((Object)key, (Object)NULL_ENTRY);
        return null;
    }

    public IType findEntity(EntityAlias alias, IScriptProject scriptProject) {
        IType[] types;
        INamespace ns;
        String key = alias + scriptProject.getElementName();
        if (this.entityCache.get((Object)key) != null) {
            return this.entityCache.get((Object)key) == NULL_ENTRY ? null : (IType)this.entityCache.get((Object)key);
        }
        Bundle bundle = this.findBundle(alias.getBundleAlias(), scriptProject);
        if (bundle == null) {
            this.entityCache.put((Object)key, (Object)NULL_ENTRY);
            return null;
        }
        try {
            ns = bundle.getNamespace();
        }
        catch (ModelException modelException) {
            return null;
        }
        if (ns == null) {
            this.entityCache.put((Object)key, (Object)NULL_ENTRY);
            return null;
        }
        String[] entityNS = new String[ns.getStrings().length + 1];
        System.arraycopy(ns.getStrings(), 0, entityNS, 0, ns.getStrings().length);
        entityNS[ns.getStrings().length] = "Entity";
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)scriptProject);
        StringBuilder sb = new StringBuilder();
        sb.append(entityNS[0]);
        int i = 1;
        while (i < entityNS.length) {
            sb.append("\\");
            sb.append(entityNS[i]);
            ++i;
        }
        String entity = alias.getEntity();
        if (entity.contains("\\")) {
            String[] strings = entity.split("\\\\");
            int i2 = 0;
            while (i2 < strings.length) {
                if (i2 < strings.length - 1) {
                    sb.append("\\");
                    sb.append(strings[i2]);
                } else {
                    entity = strings[i2];
                }
                ++i2;
            }
        }
        if ((types = this.findTypes(sb.toString(), entity, ISearchEngine.MatchRule.EXACT, 0, 0, scope, null)).length == 1) {
            IType t = types[0];
            this.entityCache.put((Object)key, (Object)t);
            return t;
        }
        this.entityCache.put((Object)key, (Object)NULL_ENTRY);
        return null;
    }

    public List<TransUnit> findTranslations(IPath path) {
        final ArrayList<TransUnit> translations = new ArrayList<TransUnit>();
        if (this.index == null) {
            Logger.log(4, "The SymfonyIndexer has not been instantiated...");
            return null;
        }
        this.index.findTranslations(path.toString(), new ITranslationHandler(){

            public void handle(String name, String value, String language, String path) {
                TransUnit trans = new TransUnit(name, value, language, path);
                translations.add(trans);
            }
        });
        return translations;
    }

    public List<TransUnit> findTranslations(Translation translation) {
        final ArrayList<TransUnit> units = new ArrayList<TransUnit>();
        this.index.findTranslations(translation.getElementName(), translation.getPath().toString(), new ITranslationHandler(){

            public void handle(String name, String value, String language, String path) {
                TransUnit unit = new TransUnit(name, value, language);
                units.add(unit);
            }
        });
        return units;
    }

    public Route getRoute(IType type, IMethod method) {
        IScriptProject project = type.getScriptProject();
        String bundleAlias = ModelUtils.extractBundleName(type.getFullyQualifiedName("\\"));
        String controller = ModelUtils.getControllerName(type);
        List routes = this.index.findRoutesByController(bundleAlias, controller, project.getPath());
        String action = method.getElementName().endsWith("Action") ? method.getElementName().replace("Action", "") : method.getElementName();
        for (Route route : routes) {
            if (!route.getAction().equals(action)) continue;
            return route;
        }
        return null;
    }

    public List<SymfonyElementResolver.TemplateField> findTemplateVariables(ISourceModule sourceModule, String varName) {
        String viewPath = PathUtils.createViewPathFromTemplate(sourceModule, false);
        IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)sourceModule.getScriptProject());
        ISearchEngine engine = ModelAccess.getSearchEngine((IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
        if (scope == null || engine == null) {
            return null;
        }
        final ArrayList<SymfonyElementResolver.TemplateField> variables = new ArrayList<SymfonyElementResolver.TemplateField>();
        final IElementResolver resolver = ModelAccess.getElementResolver((IDLTKLanguageToolkit)PHPLanguageToolkit.getDefault());
        if (!varName.startsWith("$")) {
            varName = "$" + varName;
        }
        engine.search(402, viewPath, varName, 0, 0, 100, ISearchEngine.SearchFor.REFERENCES, ISearchEngine.MatchRule.EXACT, scope, new ISearchRequestor(){

            public void match(int elementType, int flags, int offset, int length, int nameOffset, int nameLength, String elementName, String metadata, String doc, String qualifier, String parent, ISourceModule sourceModule, boolean isReference) {
                IModelElement element = resolver.resolve(elementType, flags, offset, length, nameOffset, nameLength, elementName, metadata, doc, qualifier, parent, sourceModule);
                if (element != null && element instanceof SymfonyElementResolver.TemplateField) {
                    variables.add((SymfonyElementResolver.TemplateField)element);
                }
            }
        }, null);
        return variables;
    }

    private class ReturnTypeVisitor
    extends PHPASTVisitor {
        public String namespace;
        public String className;
        private String method;

        public ReturnTypeVisitor(String method) {
            this.method = method;
        }

        public boolean visit(NamespaceDeclaration s) throws Exception {
            this.namespace = s.getName();
            return true;
        }

        public boolean visit(PHPMethodDeclaration s) throws Exception {
            PHPDocTag tag;
            PHPDocBlock docs;
            PHPDocTag[] returnTags;
            if (s.getName().equals(this.method) && (returnTags = (docs = s.getPHPDoc()).getTags(PHPDocTag.TagKind.RETURN)).length == 1 && (tag = returnTags[0]).getTypeReferences().size() == 1) {
                SimpleReference ref = (SimpleReference)tag.getTypeReferences().get(0);
                this.className = ref.getName();
                return false;
            }
            return true;
        }
    }
}

